/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.config;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorManager;
import com.jfinal.core.Controller;
import com.jfinal.kit.StrKit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Routes {
    private static List<Routes> routesList = new ArrayList<Routes>();
    private static Set<String> controllerKeySet = new HashSet<String>();
    private String baseViewPath = null;
    private List<Route> routeItemList = new ArrayList<Route>();
    private List<Interceptor> injectInters = new ArrayList<Interceptor>();

    public abstract void config();

    public Routes add(Routes routes) {
        routes.config();
        routesList.add(routes);
        return this;
    }

    public Routes add(String controllerKey, Class<? extends Controller> controllerClass, String viewPath) {
        this.routeItemList.add(new Route(controllerKey, controllerClass, viewPath));
        return this;
    }

    public Routes add(String controllerKey, Class<? extends Controller> controllerClass) {
        return this.add(controllerKey, controllerClass, controllerKey);
    }

    public Routes addInterceptor(Interceptor interceptor) {
        this.injectInters.add(interceptor);
        return this;
    }

    public Routes setBaseViewPath(String baseViewPath) {
        if (StrKit.isBlank(baseViewPath)) {
            throw new IllegalArgumentException("baseViewPath can not be blank");
        }
        if (!(baseViewPath = baseViewPath.trim()).startsWith("/")) {
            baseViewPath = "/" + baseViewPath;
        }
        if (baseViewPath.endsWith("/")) {
            baseViewPath = baseViewPath.substring(0, baseViewPath.length() - 1);
        }
        this.baseViewPath = baseViewPath;
        return this;
    }

    public String getBaseViewPath() {
        return this.baseViewPath;
    }

    public static List<Routes> getRoutesList() {
        return routesList;
    }

    public List<Route> getRouteItemList() {
        return this.routeItemList;
    }

    public Interceptor[] getInterceptors() {
        return this.injectInters.size() > 0 ? this.injectInters.toArray(new Interceptor[this.injectInters.size()]) : InterceptorManager.NULL_INTERS;
    }

    public void clear() {
        routesList = null;
        controllerKeySet = null;
        this.baseViewPath = null;
        this.routeItemList = null;
        this.injectInters = null;
    }

    public static class Route {
        private String controllerKey;
        private Class<? extends Controller> controllerClass;
        private String viewPath;

        public Route(String controllerKey, Class<? extends Controller> controllerClass, String viewPath) {
            if (StrKit.isBlank(controllerKey)) {
                throw new IllegalArgumentException("controllerKey can not be blank");
            }
            if (controllerClass == null) {
                throw new IllegalArgumentException("controllerClass can not be null");
            }
            if (StrKit.isBlank(viewPath)) {
                viewPath = "/";
            }
            this.controllerKey = this.processControllerKey(controllerKey);
            this.controllerClass = controllerClass;
            this.viewPath = this.processViewPath(viewPath);
        }

        private String processControllerKey(String controllerKey) {
            if (!(controllerKey = controllerKey.trim()).startsWith("/")) {
                controllerKey = "/" + controllerKey;
            }
            if (controllerKeySet.contains(controllerKey)) {
                throw new IllegalArgumentException("controllerKey already exists: " + controllerKey);
            }
            controllerKeySet.add(controllerKey);
            return controllerKey;
        }

        private String processViewPath(String viewPath) {
            if (!(viewPath = viewPath.trim()).startsWith("/")) {
                viewPath = "/" + viewPath;
            }
            if (!viewPath.endsWith("/")) {
                viewPath = viewPath + "/";
            }
            return viewPath;
        }

        public String getControllerKey() {
            return this.controllerKey;
        }

        public Class<? extends Controller> getControllerClass() {
            return this.controllerClass;
        }

        public String getFinalViewPath(String baseViewPath) {
            return baseViewPath != null ? baseViewPath + this.viewPath : this.viewPath;
        }
    }
}

