/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.expr.Sym;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Scope;

public class Const
extends Expr {
    public static final Const TRUE = new Const(Boolean.TRUE, Sym.TRUE);
    public static final Const FALSE = new Const(Boolean.FALSE, Sym.FALSE);
    public static final Const NULL = new Const(null, Sym.NULL);
    private Sym type;
    private Object value;

    private Const(Object value, Sym type) {
        this.type = type;
        this.value = value;
    }

    public Const(Sym type, String value) {
        this.type = type;
        this.value = this.typeConvert(type, value);
    }

    private Object typeConvert(Sym type, String value) {
        switch (type) {
            case STR: {
                return value;
            }
            case INT: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case DOUBLE: {
                return Double.parseDouble(value);
            }
        }
        throw new RuntimeException("never happend");
    }

    @Override
    public Object eval(Scope scope) {
        return this.value;
    }

    public boolean isStr() {
        return this.type == Sym.STR;
    }

    public boolean isTrue() {
        return this.type == Sym.TRUE;
    }

    public boolean isFalse() {
        return this.type == Sym.FALSE;
    }

    public boolean isBoolean() {
        return this.type == Sym.TRUE || this.type == Sym.FALSE;
    }

    public boolean isNull() {
        return this.type == Sym.NULL;
    }

    public boolean isInt() {
        return this.type == Sym.INT;
    }

    public boolean isLong() {
        return this.type == Sym.LONG;
    }

    public boolean isFloat() {
        return this.type == Sym.FLOAT;
    }

    public boolean isDouble() {
        return this.type == Sym.DOUBLE;
    }

    public Object getValue() {
        return this.value;
    }

    public String getStr() {
        return (String)this.value;
    }

    public Boolean getBoolean() {
        return (Boolean)this.value;
    }

    public Integer getInt() {
        return (Integer)this.value;
    }

    public Long getLong() {
        return (Long)this.value;
    }

    public Float getFloat() {
        return (Float)this.value;
    }

    public Double getDouble() {
        return (Double)this.value;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "null";
    }
}

