/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.template.expr.ast;

import com.jfinal.template.TemplateException;
import com.jfinal.template.expr.ast.Expr;
import com.jfinal.template.stat.Location;
import com.jfinal.template.stat.ParseException;
import com.jfinal.template.stat.Scope;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

public class Index
extends Expr {
    private Expr expr;
    private Expr index;

    public Index(Expr expr, Expr index, Location location) {
        if (expr == null || index == null) {
            throw new ParseException("array/list/map and their index can not be null", location);
        }
        this.expr = expr;
        this.index = index;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object array = this.expr.eval(scope);
        if (array == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException("The index access operation target can not be null", this.location);
        }
        Object idx = this.index.eval(scope);
        if (idx == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException("The index of list/array and the key of map can not be null", this.location);
        }
        if (array instanceof List) {
            if (idx instanceof Integer) {
                return ((List)array).get((Integer)idx);
            }
            throw new TemplateException("The index of list can only be integer", this.location);
        }
        if (array instanceof Map) {
            return ((Map)array).get(idx);
        }
        if (array.getClass().isArray()) {
            if (idx instanceof Integer) {
                return Array.get(array, (Integer)idx);
            }
            throw new TemplateException("The index of array can only be integer", this.location);
        }
        throw new TemplateException("Only the list array and map is supported by index access", this.location);
    }
}

