/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.validate;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.kit.LogKit;
import com.jfinal.kit.StrKit;
import com.jfinal.validate.ValidateException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Validator
implements Interceptor {
    protected Controller controller;
    protected Invocation invocation;
    protected boolean shortCircuit = false;
    protected boolean invalid = false;
    protected String datePattern = null;
    protected static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    protected static final String emailAddressPattern = "\\b(^['_A-Za-z0-9-]+(\\.['_A-Za-z0-9-]+)*@([A-Za-z0-9-])+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z0-9]{2,})|(\\.[A-Za-z0-9]{2,}\\.[A-Za-z0-9]{2,}))$)\\b";

    protected void setShortCircuit(boolean shortCircuit) {
        this.shortCircuit = shortCircuit;
    }

    protected void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    protected String getDatePattern() {
        return this.datePattern != null ? this.datePattern : DEFAULT_DATE_PATTERN;
    }

    @Override
    public final void intercept(Invocation invocation) {
        Validator validator = null;
        try {
            validator = (Validator)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        validator.controller = invocation.getController();
        validator.invocation = invocation;
        try {
            validator.validate(validator.controller);
        }
        catch (ValidateException e) {
            LogKit.logNothing(e);
        }
        if (validator.invalid) {
            validator.handleError(validator.controller);
        } else {
            invocation.invoke();
        }
    }

    protected abstract void validate(Controller var1);

    protected abstract void handleError(Controller var1);

    protected void addError(String errorKey, String errorMessage) {
        this.invalid = true;
        this.controller.setAttr(errorKey, errorMessage);
        if (this.shortCircuit) {
            throw new ValidateException();
        }
    }

    protected Controller getController() {
        return this.controller;
    }

    protected String getActionKey() {
        return this.invocation.getActionKey();
    }

    protected String getControllerKey() {
        return this.invocation.getControllerKey();
    }

    protected Method getActionMethod() {
        return this.invocation.getMethod();
    }

    protected String getActionMethodName() {
        return this.invocation.getMethodName();
    }

    protected String getViewPath() {
        return this.invocation.getViewPath();
    }

    protected void validateRequired(String field, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (value == null || "".equals(value)) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateRequired(int index, String errorKey, String errorMessage) {
        String value = this.controller.getPara(index);
        if (value == null) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateRequiredString(String field, String errorKey, String errorMessage) {
        if (StrKit.isBlank(this.controller.getPara(field))) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateRequiredString(int index, String errorKey, String errorMessage) {
        if (StrKit.isBlank(this.controller.getPara(index))) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateInteger(String field, int min, int max, String errorKey, String errorMessage) {
        this.validateIntegerValue(this.controller.getPara(field), min, max, errorKey, errorMessage);
    }

    protected void validateInteger(int index, int min, int max, String errorKey, String errorMessage) {
        String value = this.controller.getPara(index);
        if (value != null && (value.startsWith("N") || value.startsWith("n"))) {
            value = "-" + value.substring(1);
        }
        this.validateIntegerValue(value, min, max, errorKey, errorMessage);
    }

    private void validateIntegerValue(String value, int min, int max, String errorKey, String errorMessage) {
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            int temp = Integer.parseInt(value.trim());
            if (temp < min || temp > max) {
                this.addError(errorKey, errorMessage);
            }
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateInteger(String field, String errorKey, String errorMessage) {
        this.validateIntegerValue(this.controller.getPara(field), errorKey, errorMessage);
    }

    protected void validateInteger(int index, String errorKey, String errorMessage) {
        String value = this.controller.getPara(index);
        if (value != null && (value.startsWith("N") || value.startsWith("n"))) {
            value = "-" + value.substring(1);
        }
        this.validateIntegerValue(value, errorKey, errorMessage);
    }

    private void validateIntegerValue(String value, String errorKey, String errorMessage) {
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            Integer.parseInt(value.trim());
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateLong(String field, long min, long max, String errorKey, String errorMessage) {
        this.validateLongValue(this.controller.getPara(field), min, max, errorKey, errorMessage);
    }

    protected void validateLong(int index, long min, long max, String errorKey, String errorMessage) {
        String value = this.controller.getPara(index);
        if (value != null && (value.startsWith("N") || value.startsWith("n"))) {
            value = "-" + value.substring(1);
        }
        this.validateLongValue(value, min, max, errorKey, errorMessage);
    }

    private void validateLongValue(String value, long min, long max, String errorKey, String errorMessage) {
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            long temp = Long.parseLong(value.trim());
            if (temp < min || temp > max) {
                this.addError(errorKey, errorMessage);
            }
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateLong(String field, String errorKey, String errorMessage) {
        this.validateLongValue(this.controller.getPara(field), errorKey, errorMessage);
    }

    protected void validateLong(int index, String errorKey, String errorMessage) {
        String value = this.controller.getPara(index);
        if (value != null && (value.startsWith("N") || value.startsWith("n"))) {
            value = "-" + value.substring(1);
        }
        this.validateLongValue(value, errorKey, errorMessage);
    }

    private void validateLongValue(String value, String errorKey, String errorMessage) {
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            Long.parseLong(value.trim());
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDouble(String field, double min, double max, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            double temp = Double.parseDouble(value.trim());
            if (temp < min || temp > max) {
                this.addError(errorKey, errorMessage);
            }
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDouble(String field, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            Double.parseDouble(value.trim());
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDate(String field, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            new SimpleDateFormat(this.getDatePattern()).parse(value.trim());
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDate(String field, Date min, Date max, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            Date temp = new SimpleDateFormat(this.getDatePattern()).parse(value.trim());
            if (temp.before(min) || temp.after(max)) {
                this.addError(errorKey, errorMessage);
            }
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateDate(String field, String min, String max, String errorKey, String errorMessage) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(this.getDatePattern());
            this.validateDate(field, sdf.parse(min.trim()), sdf.parse(max.trim()), errorKey, errorMessage);
        }
        catch (Exception e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateEqualField(String field_1, String field_2, String errorKey, String errorMessage) {
        String value_1 = this.controller.getPara(field_1);
        String value_2 = this.controller.getPara(field_2);
        if (value_1 == null || value_2 == null || !value_1.equals(value_2)) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateEqualString(String s1, String s2, String errorKey, String errorMessage) {
        if (s1 == null || s2 == null || !s1.equals(s2)) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateEqualInteger(Integer i1, Integer i2, String errorKey, String errorMessage) {
        if (i1 == null || i2 == null || i1.intValue() != i2.intValue()) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateEmail(String field, String errorKey, String errorMessage) {
        this.validateRegex(field, emailAddressPattern, false, errorKey, errorMessage);
    }

    protected void validateUrl(String field, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        try {
            value = value.trim();
            if (value.startsWith("https://")) {
                value = "http://" + value.substring(8);
            }
            new URL(value);
        }
        catch (MalformedURLException e) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateRegex(String field, String regExpression, boolean isCaseSensitive, String errorKey, String errorMessage) {
        String value = this.controller.getPara(field);
        if (value == null) {
            this.addError(errorKey, errorMessage);
            return;
        }
        Pattern pattern = isCaseSensitive ? Pattern.compile(regExpression) : Pattern.compile(regExpression, 2);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateRegex(String field, String regExpression, String errorKey, String errorMessage) {
        this.validateRegex(field, regExpression, true, errorKey, errorMessage);
    }

    protected void validateString(String field, int minLen, int maxLen, String errorKey, String errorMessage) {
        this.validateStringValue(this.controller.getPara(field), minLen, maxLen, errorKey, errorMessage);
    }

    protected void validateString(int index, int minLen, int maxLen, String errorKey, String errorMessage) {
        this.validateStringValue(this.controller.getPara(index), minLen, maxLen, errorKey, errorMessage);
    }

    private void validateStringValue(String value, int minLen, int maxLen, String errorKey, String errorMessage) {
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        if (value.length() < minLen || value.length() > maxLen) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateToken(String tokenName, String errorKey, String errorMessage) {
        if (!this.controller.validateToken(tokenName)) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateToken(String errorKey, String errorMessage) {
        if (!this.controller.validateToken()) {
            this.addError(errorKey, errorMessage);
        }
    }

    protected void validateBoolean(String field, String errorKey, String errorMessage) {
        this.validateBooleanValue(this.controller.getPara(field), errorKey, errorMessage);
    }

    protected void validateBoolean(int index, String errorKey, String errorMessage) {
        this.validateBooleanValue(this.controller.getPara(index), errorKey, errorMessage);
    }

    private void validateBooleanValue(String value, String errorKey, String errorMessage) {
        if (StrKit.isBlank(value)) {
            this.addError(errorKey, errorMessage);
            return;
        }
        if ("1".equals(value = value.trim().toLowerCase()) || "true".equals(value)) {
            return;
        }
        if ("0".equals(value) || "false".equals(value)) {
            return;
        }
        this.addError(errorKey, errorMessage);
    }

    protected void validateCaptcha(String field, String errorKey, String errorMessage) {
        if (!this.getController().validateCaptcha(field)) {
            this.addError(errorKey, errorMessage);
        }
    }
}

