/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.demo;

import com.jfinal.core.Controller;
import com.jfinal.kit.HttpKit;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.PaymentApi;
import com.jfinal.weixin.sdk.kit.IpKit;
import com.jfinal.weixin.sdk.kit.PaymentKit;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WeixinPayController
extends Controller {
    private static String appid = "";
    private static String partner = "";
    private static String paternerKey = "";
    private static String notify_url = "http://www.xxx.com/pay/pay_notify";

    public void index() {
        String openId = "";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", appid);
        params.put("mch_id", partner);
        params.put("body", "JFinal2.0\u6781\u901f\u5f00\u53d1");
        params.put("out_trade_no", "977773682111");
        params.put("total_fee", "1");
        String ip = IpKit.getRealIp(this.getRequest());
        if (StrKit.isBlank((String)ip)) {
            ip = "127.0.0.1";
        }
        params.put("spbill_create_ip", ip);
        params.put("trade_type", PaymentApi.TradeType.JSAPI.name());
        params.put("nonce_str", System.currentTimeMillis() / 1000L + "");
        params.put("notify_url", notify_url);
        params.put("openid", openId);
        String sign = PaymentKit.createSign(params, paternerKey);
        params.put("sign", sign);
        String xmlResult = PaymentApi.pushOrder(params);
        System.out.println(xmlResult);
        Map<String, String> result = PaymentKit.xmlToMap(xmlResult);
        String return_code = result.get("return_code");
        String return_msg = result.get("return_msg");
        if (StrKit.isBlank((String)return_code) || !"SUCCESS".equals(return_code)) {
            this.renderText(return_msg);
            return;
        }
        String result_code = result.get("result_code");
        if (StrKit.isBlank((String)result_code) || !"SUCCESS".equals(result_code)) {
            this.renderText(return_msg);
            return;
        }
        String prepay_id = result.get("prepay_id");
        HashMap<String, String> packageParams = new HashMap<String, String>();
        packageParams.put("appId", appid);
        packageParams.put("timeStamp", System.currentTimeMillis() / 1000L + "");
        packageParams.put("nonceStr", System.currentTimeMillis() + "");
        packageParams.put("package", "prepay_id=" + prepay_id);
        packageParams.put("signType", "MD5");
        String packageSign = PaymentKit.createSign(packageParams, paternerKey);
        packageParams.put("paySign", packageSign);
        String jsonStr = JsonUtils.toJson(packageParams);
        this.setAttr("json", jsonStr);
        System.out.println(jsonStr);
        this.render("/jsp/pay.jsp");
    }

    public void pay_notify() {
        String xmlMsg = HttpKit.readData((HttpServletRequest)this.getRequest());
        System.out.println("\u652f\u4ed8\u901a\u77e5=" + xmlMsg);
        Map<String, String> params = PaymentKit.xmlToMap(xmlMsg);
        String result_code = params.get("result_code");
        String totalFee = params.get("total_fee");
        String orderId = params.get("out_trade_no");
        String transId = params.get("transaction_id");
        String timeEnd = params.get("time_end");
        if (PaymentKit.verifyNotify(params, paternerKey) && "SUCCESS".equals(result_code)) {
            System.out.println("\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f");
            HashMap<String, String> xml = new HashMap<String, String>();
            xml.put("return_code", "SUCCESS");
            xml.put("return_msg", "OK");
            this.renderText(PaymentKit.toXml(xml));
            return;
        }
        this.renderText("");
    }
}

