/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomServiceApi {
    private static String getRecordUrl = "https://api.weixin.qq.com/customservice/msgrecord/getrecord?access_token=";
    private static String addKfAccountUrl = "https://api.weixin.qq.com/customservice/kfaccount/add?access_token=";
    private static String updateKfAccountUrl = "https://api.weixin.qq.com/customservice/kfaccount/update?access_token=";
    private static String delKfAccountUrl = "https://api.weixin.qq.com/customservice/kfaccount/del?access_token=";
    private static String uploadKfAccountHeadImgUrl = "http://api.weixin.qq.com/customservice/kfaccount/uploadheadimg?access_token=";
    private static String getKfListUrl = "https://api.weixin.qq.com/cgi-bin/customservice/getkflist?access_token=";
    private static String customMessageUrl = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";

    public static ApiResult getRecord(String jsonStr) {
        String jsonResult = HttpUtils.post(getRecordUrl + AccessTokenApi.getAccessTokenStr(), jsonStr);
        return new ApiResult(jsonResult);
    }

    public static ApiResult addKfAccount(String kf_account, String nickname, String password) {
        String accessToken = AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kf_account", kf_account);
        params.put("nickname", nickname);
        params.put("password", password);
        String jsonResult = HttpUtils.post(addKfAccountUrl + accessToken, JsonUtils.toJson(params));
        return new ApiResult(jsonResult);
    }

    public static ApiResult updateKfAccount(String kf_account, String nickname, String password) {
        String accessToken = AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kf_account", kf_account);
        params.put("nickname", nickname);
        params.put("password", password);
        String jsonResult = HttpUtils.post(updateKfAccountUrl + accessToken, JsonUtils.toJson(params));
        return new ApiResult(jsonResult);
    }

    public static ApiResult delKfAccount(String kf_account, String nickname, String password) {
        String accessToken = AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("kf_account", kf_account);
        params.put("nickname", nickname);
        params.put("password", password);
        String jsonResult = HttpUtils.post(delKfAccountUrl + accessToken, JsonUtils.toJson(params));
        return new ApiResult(jsonResult);
    }

    public static ApiResult uploadKfAccountHeadImg(String kf_account, File headImg) {
        String accessToken = AccessTokenApi.getAccessTokenStr();
        String url = uploadKfAccountHeadImgUrl + accessToken + "&kf_account=" + kf_account;
        String jsonResult = HttpUtils.upload(url, headImg, null);
        return new ApiResult(jsonResult);
    }

    public static ApiResult getKfList() {
        String accessToken = AccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpUtils.get(getKfListUrl + accessToken);
        return new ApiResult(jsonResult);
    }

    private static ApiResult sendMsg(Map<String, Object> message) {
        String accessToken = AccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpUtils.post(customMessageUrl + accessToken, JsonUtils.toJson(message));
        return new ApiResult(jsonResult);
    }

    public static ApiResult sendText(String openId, String text) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "text");
        HashMap<String, String> textObj = new HashMap<String, String>();
        textObj.put("content", text);
        json.put("text", textObj);
        return CustomServiceApi.sendMsg(json);
    }

    public static ApiResult sendImage(String openId, String media_id) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "image");
        HashMap<String, String> image = new HashMap<String, String>();
        image.put("media_id", media_id);
        json.put("image", image);
        return CustomServiceApi.sendMsg(json);
    }

    public static ApiResult sendVoice(String openId, String media_id) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "voice");
        HashMap<String, String> voice = new HashMap<String, String>();
        voice.put("media_id", media_id);
        json.put("voice", voice);
        return CustomServiceApi.sendMsg(json);
    }

    public static ApiResult sendVideo(String openId, String media_id, String title, String description) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "video");
        HashMap<String, String> video = new HashMap<String, String>();
        video.put("media_id", media_id);
        video.put("title", title);
        video.put("description", description);
        json.put("video", video);
        return CustomServiceApi.sendMsg(json);
    }

    public static ApiResult sendMusic(String openId, String musicurl, String hqmusicurl, String thumb_media_id, String title, String description) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "music");
        HashMap<String, String> music = new HashMap<String, String>();
        music.put("musicurl", musicurl);
        music.put("hqmusicurl", hqmusicurl);
        music.put("thumb_media_id", thumb_media_id);
        music.put("title", title);
        music.put("description", description);
        json.put("music", music);
        return CustomServiceApi.sendMsg(json);
    }

    public static ApiResult sendNews(String openId, List<Articles> articles) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "news");
        HashMap<String, List<Articles>> news = new HashMap<String, List<Articles>>();
        news.put("articles", articles);
        json.put("news", news);
        return CustomServiceApi.sendMsg(json);
    }

    public static ApiResult sendCoupon(String openId, String card_id, String card_ext) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "wxcard");
        HashMap<String, String> wxcard = new HashMap<String, String>();
        wxcard.put("card_id", card_id);
        wxcard.put("card_ext", card_ext);
        json.put("wxcard", wxcard);
        return CustomServiceApi.sendMsg(json);
    }

    public static class Articles {
        private String title;
        private String description;
        private String url;
        private String picurl;

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPicurl() {
            return this.picurl;
        }

        public void setPicurl(String picurl) {
            this.picurl = picurl;
        }
    }
}

