/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.api.JsTicket;
import com.jfinal.weixin.sdk.cache.IAccessTokenCache;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.RetryUtils;
import java.util.concurrent.Callable;

public class JsTicketApi {
    private static String apiUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket";
    static IAccessTokenCache accessTokenCache = ApiConfigKit.getAccessTokenCache();

    public static JsTicket getTicket(JsApiType jsApiType) {
        String access_token = AccessTokenApi.getAccessTokenStr();
        String appId = ApiConfigKit.getApiConfig().getAppId();
        String key = appId + ':' + jsApiType.name();
        final ParaMap pm = ParaMap.create("access_token", access_token).put("type", jsApiType.name());
        JsTicket jsTicket = (JsTicket)accessTokenCache.get(key);
        if (null == jsTicket || !jsTicket.isAvailable()) {
            jsTicket = RetryUtils.retryOnException(3, new Callable<JsTicket>(){

                @Override
                public JsTicket call() throws Exception {
                    return new JsTicket(HttpUtils.get(apiUrl, pm.getData()));
                }
            });
            accessTokenCache.set(key, jsTicket);
        }
        return jsTicket;
    }

    public static enum JsApiType {
        jsapi,
        wx_card;

    }
}

