/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.kit.HttpKit;
import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.api.MediaArticles;
import com.jfinal.weixin.sdk.api.MediaFile;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class MediaApi {
    private static String upload_url = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=";
    private static String uploadVideoUrl = "https://file.api.weixin.qq.com/cgi-bin/media/uploadvideo?access_token=";
    private static String get_url = "https://api.weixin.qq.com/cgi-bin/media/get?access_token=";
    private static String add_news_url = "https://api.weixin.qq.com/cgi-bin/material/add_news?access_token=";
    private static String uploadImgUrl = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=";
    private static String addMaterialUrl = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=";
    private static String get_material_url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=";
    private static String del_material_url = "https://api.weixin.qq.com/cgi-bin/material/del_material?access_token=";
    private static String update_news_url = "https://api.weixin.qq.com/cgi-bin/material/update_news?access_token=";
    private static String get_materialcount_url = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=";
    private static String batchget_material_url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=";

    public static ApiResult uploadMedia(MediaType mediaType, File file) {
        String url = upload_url + AccessTokenApi.getAccessTokenStr() + "&type=" + mediaType.get();
        String jsonStr = HttpUtils.upload(url, file, null);
        return new ApiResult(jsonStr);
    }

    public static ApiResult uploadVideo(String mediaId, String title, String description) {
        String url = uploadVideoUrl + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("media_id", mediaId);
        mapData.put("title", title);
        mapData.put("description", description);
        String jsonResult = HttpKit.post((String)url, (String)JsonUtils.toJson(mapData));
        return new ApiResult(jsonResult);
    }

    public static MediaFile getMedia(String media_id) {
        String url = get_url + AccessTokenApi.getAccessTokenStr() + "&media_id=" + media_id;
        return HttpUtils.download(url);
    }

    public static ApiResult addNews(List<MediaArticles> mediaArticles) {
        String url = add_news_url + AccessTokenApi.getAccessTokenStr();
        HashMap<String, List<MediaArticles>> dataMap = new HashMap<String, List<MediaArticles>>();
        dataMap.put("articles", mediaArticles);
        String jsonResult = HttpKit.post((String)url, (String)JsonUtils.toJson(dataMap));
        return new ApiResult(jsonResult);
    }

    public static ApiResult uploadImg(File imgFile) {
        String url = uploadImgUrl + AccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpUtils.upload(url, imgFile, null);
        return new ApiResult(jsonResult);
    }

    public static ApiResult addMaterial(File file) {
        String url = addMaterialUrl + AccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpUtils.upload(url, file, null);
        return new ApiResult(jsonResult);
    }

    public static ApiResult addMaterial(File file, String title, String introduction) {
        String url = addMaterialUrl + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("title", title);
        dataMap.put("introduction", introduction);
        String jsonResult = HttpUtils.upload(url, file, JsonUtils.toJson(dataMap));
        return new ApiResult(jsonResult);
    }

    public static InputStream getMaterial(String media_id) {
        String url = get_material_url + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("media_id", media_id);
        return HttpUtils.download(url, JsonUtils.toJson(dataMap));
    }

    public static ApiResult delMaterial(String media_id) {
        String url = del_material_url + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("media_id", media_id);
        String jsonResult = HttpKit.post((String)url, (String)JsonUtils.toJson(dataMap));
        return new ApiResult(jsonResult);
    }

    public static ApiResult updateNews(String media_id, int index, MediaArticles mediaArticles) {
        String url = update_news_url + AccessTokenApi.getAccessTokenStr();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("media_id", media_id);
        dataMap.put("index", index);
        dataMap.put("articles", mediaArticles);
        String jsonResult = HttpKit.post((String)url, (String)JsonUtils.toJson(dataMap));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getMaterialCount() {
        String url = get_materialcount_url + AccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpKit.get((String)url);
        return new ApiResult(jsonResult);
    }

    public static ApiResult batchGetMaterial(MediaType mediaType, int offset, int count) {
        String url = batchget_material_url + AccessTokenApi.getAccessTokenStr();
        if (offset < 0) {
            offset = 0;
        }
        if (count > 20) {
            count = 20;
        }
        if (count < 1) {
            count = 1;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("type", mediaType.get());
        dataMap.put("offset", offset);
        dataMap.put("count", count);
        String jsonResult = HttpKit.post((String)url, (String)JsonUtils.toJson(dataMap));
        return new ApiResult(jsonResult);
    }

    public static enum MediaType {
        IMAGE,
        VOICE,
        VIDEO,
        THUMB,
        NEWS;


        public String get() {
            return this.name().toLowerCase();
        }
    }
}

