/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.jfinal;

import com.jfinal.aop.Before;
import com.jfinal.core.Controller;
import com.jfinal.ext.interceptor.NotAction;
import com.jfinal.kit.HttpKit;
import com.jfinal.log.Log;
import com.jfinal.weixin.sdk.api.ApiConfig;
import com.jfinal.weixin.sdk.api.ApiConfigKit;
import com.jfinal.weixin.sdk.jfinal.MsgInterceptor;
import com.jfinal.weixin.sdk.kit.MsgEncryptKit;
import com.jfinal.weixin.sdk.msg.InMsgParser;
import com.jfinal.weixin.sdk.msg.OutMsgXmlBuilder;
import com.jfinal.weixin.sdk.msg.in.InImageMsg;
import com.jfinal.weixin.sdk.msg.in.InLinkMsg;
import com.jfinal.weixin.sdk.msg.in.InLocationMsg;
import com.jfinal.weixin.sdk.msg.in.InMsg;
import com.jfinal.weixin.sdk.msg.in.InShortVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InTextMsg;
import com.jfinal.weixin.sdk.msg.in.InVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InVoiceMsg;
import com.jfinal.weixin.sdk.msg.in.event.InCustomEvent;
import com.jfinal.weixin.sdk.msg.in.event.InFollowEvent;
import com.jfinal.weixin.sdk.msg.in.event.InLocationEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMassEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMenuEvent;
import com.jfinal.weixin.sdk.msg.in.event.InPoiCheckNotifyEvent;
import com.jfinal.weixin.sdk.msg.in.event.InQrCodeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InShakearoundUserShakeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InTemplateMsgEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifyFailEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifySuccessEvent;
import com.jfinal.weixin.sdk.msg.in.speech_recognition.InSpeechRecognitionResults;
import com.jfinal.weixin.sdk.msg.out.OutMsg;
import com.jfinal.weixin.sdk.msg.out.OutTextMsg;
import javax.servlet.http.HttpServletRequest;

public abstract class MsgController
extends Controller {
    private static final Log log = Log.getLog(MsgController.class);
    private String inMsgXml = null;
    private InMsg inMsg = null;

    public abstract ApiConfig getApiConfig();

    @Before(value={MsgInterceptor.class})
    public void index() {
        InMsg msg;
        if (ApiConfigKit.isDevMode()) {
            System.out.println("\u63a5\u6536\u6d88\u606f:");
            System.out.println(this.getInMsgXml());
        }
        if ((msg = this.getInMsg()) instanceof InTextMsg) {
            this.processInTextMsg((InTextMsg)msg);
        } else if (msg instanceof InImageMsg) {
            this.processInImageMsg((InImageMsg)msg);
        } else if (msg instanceof InVoiceMsg) {
            this.processInVoiceMsg((InVoiceMsg)msg);
        } else if (msg instanceof InVideoMsg) {
            this.processInVideoMsg((InVideoMsg)msg);
        } else if (msg instanceof InShortVideoMsg) {
            this.processInShortVideoMsg((InShortVideoMsg)msg);
        } else if (msg instanceof InLocationMsg) {
            this.processInLocationMsg((InLocationMsg)msg);
        } else if (msg instanceof InLinkMsg) {
            this.processInLinkMsg((InLinkMsg)msg);
        } else if (msg instanceof InCustomEvent) {
            this.processInCustomEvent((InCustomEvent)msg);
        } else if (msg instanceof InFollowEvent) {
            this.processInFollowEvent((InFollowEvent)msg);
        } else if (msg instanceof InQrCodeEvent) {
            this.processInQrCodeEvent((InQrCodeEvent)msg);
        } else if (msg instanceof InLocationEvent) {
            this.processInLocationEvent((InLocationEvent)msg);
        } else if (msg instanceof InMassEvent) {
            this.processInMassEvent((InMassEvent)msg);
        } else if (msg instanceof InMenuEvent) {
            this.processInMenuEvent((InMenuEvent)msg);
        } else if (msg instanceof InSpeechRecognitionResults) {
            this.processInSpeechRecognitionResults((InSpeechRecognitionResults)msg);
        } else if (msg instanceof InTemplateMsgEvent) {
            this.processInTemplateMsgEvent((InTemplateMsgEvent)msg);
        } else if (msg instanceof InShakearoundUserShakeEvent) {
            this.processInShakearoundUserShakeEvent((InShakearoundUserShakeEvent)msg);
        } else if (msg instanceof InVerifySuccessEvent) {
            this.processInVerifySuccessEvent((InVerifySuccessEvent)msg);
        } else if (msg instanceof InVerifyFailEvent) {
            this.processInVerifyFailEvent((InVerifyFailEvent)msg);
        } else if (msg instanceof InPoiCheckNotifyEvent) {
            this.processInPoiCheckNotifyEvent((InPoiCheckNotifyEvent)msg);
        } else {
            log.error("\u672a\u80fd\u8bc6\u522b\u7684\u6d88\u606f\u7c7b\u578b\u3002 \u6d88\u606f xml \u5185\u5bb9\u4e3a\uff1a\n" + this.getInMsgXml());
        }
    }

    public void render(OutMsg outMsg) {
        String outMsgXml = OutMsgXmlBuilder.build(outMsg);
        if (ApiConfigKit.isDevMode()) {
            System.out.println("\u53d1\u9001\u6d88\u606f:");
            System.out.println(outMsgXml);
            System.out.println("--------------------------------------------------------------------------------\n");
        }
        if (ApiConfigKit.getApiConfig().isEncryptMessage()) {
            outMsgXml = MsgEncryptKit.encrypt(outMsgXml, this.getPara("timestamp"), this.getPara("nonce"));
        }
        this.renderText(outMsgXml, "text/xml");
    }

    public void renderOutTextMsg(String content) {
        OutTextMsg outMsg = new OutTextMsg(this.getInMsg());
        outMsg.setContent(content);
        this.render(outMsg);
    }

    @Before(value={NotAction.class})
    public String getInMsgXml() {
        if (this.inMsgXml == null) {
            this.inMsgXml = HttpKit.readData((HttpServletRequest)this.getRequest());
            if (ApiConfigKit.getApiConfig().isEncryptMessage()) {
                this.inMsgXml = MsgEncryptKit.decrypt(this.inMsgXml, this.getPara("timestamp"), this.getPara("nonce"), this.getPara("msg_signature"));
            }
        }
        return this.inMsgXml;
    }

    @Before(value={NotAction.class})
    public InMsg getInMsg() {
        if (this.inMsg == null) {
            this.inMsg = InMsgParser.parse(this.getInMsgXml());
        }
        return this.inMsg;
    }

    protected abstract void processInTextMsg(InTextMsg var1);

    protected abstract void processInImageMsg(InImageMsg var1);

    protected abstract void processInVoiceMsg(InVoiceMsg var1);

    protected abstract void processInVideoMsg(InVideoMsg var1);

    protected abstract void processInShortVideoMsg(InShortVideoMsg var1);

    protected abstract void processInLocationMsg(InLocationMsg var1);

    protected abstract void processInLinkMsg(InLinkMsg var1);

    protected abstract void processInCustomEvent(InCustomEvent var1);

    protected abstract void processInFollowEvent(InFollowEvent var1);

    protected abstract void processInQrCodeEvent(InQrCodeEvent var1);

    protected abstract void processInLocationEvent(InLocationEvent var1);

    protected abstract void processInMassEvent(InMassEvent var1);

    protected abstract void processInMenuEvent(InMenuEvent var1);

    protected abstract void processInSpeechRecognitionResults(InSpeechRecognitionResults var1);

    protected abstract void processInTemplateMsgEvent(InTemplateMsgEvent var1);

    protected abstract void processInShakearoundUserShakeEvent(InShakearoundUserShakeEvent var1);

    protected abstract void processInVerifySuccessEvent(InVerifySuccessEvent var1);

    protected abstract void processInVerifyFailEvent(InVerifyFailEvent var1);

    protected abstract void processInPoiCheckNotifyEvent(InPoiCheckNotifyEvent var1);
}

