/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.kit;

import com.jfinal.weixin.sdk.utils.IOUtils;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlKit {
    private XmlKit() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parse(String xmlStr) {
        Document document;
        DocumentBuilderFactory dbf = XmlKit.getDocumentBuilderFactory();
        StringReader sr = null;
        try {
            Document document2;
            DocumentBuilder db = dbf.newDocumentBuilder();
            sr = new StringReader(xmlStr);
            InputSource is = new InputSource(sr);
            document = document2 = db.parse(is);
        }
        catch (ParserConfigurationException e) {
            try {
                throw new RuntimeException(e);
                catch (SAXException e2) {
                    throw new RuntimeException(e2);
                }
                catch (IOException e3) {
                    throw new RuntimeException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(sr);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(sr);
        return document;
    }

    public static String elementText(Element element, String name) {
        NodeList node = element.getElementsByTagName(name);
        if (node.getLength() == 0) {
            return null;
        }
        return node.item(0).getTextContent();
    }

    public static String documentText(Document doc, String name) {
        NodeList node = doc.getElementsByTagName(name);
        if (node.getLength() == 0) {
            return null;
        }
        return node.item(0).getTextContent();
    }

    public static Document element(Element element, String name) {
        NodeList list = element.getElementsByTagName(name);
        if (list.getLength() == 0) {
            return null;
        }
        return list.item(0).getOwnerDocument();
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        return DocumentBuilderFactoryHolder.INSTANCE;
    }

    private static class DocumentBuilderFactoryHolder {
        private static DocumentBuilderFactory INSTANCE = DocumentBuilderFactory.newInstance();

        private DocumentBuilderFactoryHolder() {
        }
    }
}

