/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.msg;

import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.kit.XmlKit;
import com.jfinal.weixin.sdk.msg.in.InImageMsg;
import com.jfinal.weixin.sdk.msg.in.InLinkMsg;
import com.jfinal.weixin.sdk.msg.in.InLocationMsg;
import com.jfinal.weixin.sdk.msg.in.InMsg;
import com.jfinal.weixin.sdk.msg.in.InShortVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InTextMsg;
import com.jfinal.weixin.sdk.msg.in.InVideoMsg;
import com.jfinal.weixin.sdk.msg.in.InVoiceMsg;
import com.jfinal.weixin.sdk.msg.in.event.InCustomEvent;
import com.jfinal.weixin.sdk.msg.in.event.InFollowEvent;
import com.jfinal.weixin.sdk.msg.in.event.InLocationEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMassEvent;
import com.jfinal.weixin.sdk.msg.in.event.InMenuEvent;
import com.jfinal.weixin.sdk.msg.in.event.InPoiCheckNotifyEvent;
import com.jfinal.weixin.sdk.msg.in.event.InQrCodeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InShakearoundUserShakeEvent;
import com.jfinal.weixin.sdk.msg.in.event.InTemplateMsgEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifyFailEvent;
import com.jfinal.weixin.sdk.msg.in.event.InVerifySuccessEvent;
import com.jfinal.weixin.sdk.msg.in.event.ScanCodeInfo;
import com.jfinal.weixin.sdk.msg.in.speech_recognition.InSpeechRecognitionResults;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InMsgParser {
    private InMsgParser() {
    }

    public static InMsg parse(String xml) {
        Document doc = XmlKit.parse(xml);
        return InMsgParser.doParse(doc);
    }

    private static InMsg doParse(Document doc) {
        Element root = doc.getDocumentElement();
        String toUserName = XmlKit.elementText(root, "ToUserName");
        String fromUserName = XmlKit.elementText(root, "FromUserName");
        Integer createTime = Integer.parseInt(XmlKit.elementText(root, "CreateTime"));
        String msgType = XmlKit.elementText(root, "MsgType");
        if ("text".equals(msgType)) {
            return InMsgParser.parseInTextMsg(root, toUserName, fromUserName, createTime, msgType);
        }
        if ("image".equals(msgType)) {
            return InMsgParser.parseInImageMsg(root, toUserName, fromUserName, createTime, msgType);
        }
        if ("voice".equals(msgType)) {
            return InMsgParser.parseInVoiceMsgAndInSpeechRecognitionResults(root, toUserName, fromUserName, createTime, msgType);
        }
        if ("video".equals(msgType)) {
            return InMsgParser.parseInVideoMsg(root, toUserName, fromUserName, createTime, msgType);
        }
        if ("shortvideo".equals(msgType)) {
            return InMsgParser.parseInShortVideoMsg(root, toUserName, fromUserName, createTime, msgType);
        }
        if ("location".equals(msgType)) {
            return InMsgParser.parseInLocationMsg(root, toUserName, fromUserName, createTime, msgType);
        }
        if ("link".equals(msgType)) {
            return InMsgParser.parseInLinkMsg(root, toUserName, fromUserName, createTime, msgType);
        }
        if ("event".equals(msgType)) {
            return InMsgParser.parseInEvent(root, toUserName, fromUserName, createTime, msgType);
        }
        throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u6d88\u606f\u7c7b\u578b " + msgType + "\uff0c\u8bf7\u67e5\u9605\u5fae\u4fe1\u516c\u4f17\u5e73\u53f0\u5f00\u53d1\u6587\u6863");
    }

    private static InMsg parseInTextMsg(Element root, String toUserName, String fromUserName, Integer createTime, String msgType) {
        InTextMsg msg = new InTextMsg(toUserName, fromUserName, createTime, msgType);
        msg.setContent(XmlKit.elementText(root, "Content"));
        msg.setMsgId(XmlKit.elementText(root, "MsgId"));
        return msg;
    }

    private static InMsg parseInImageMsg(Element root, String toUserName, String fromUserName, Integer createTime, String msgType) {
        InImageMsg msg = new InImageMsg(toUserName, fromUserName, createTime, msgType);
        msg.setPicUrl(XmlKit.elementText(root, "PicUrl"));
        msg.setMediaId(XmlKit.elementText(root, "MediaId"));
        msg.setMsgId(XmlKit.elementText(root, "MsgId"));
        return msg;
    }

    private static InMsg parseInVoiceMsgAndInSpeechRecognitionResults(Element root, String toUserName, String fromUserName, Integer createTime, String msgType) {
        String recognition = XmlKit.elementText(root, "Recognition");
        if (StrKit.isBlank((String)recognition)) {
            InVoiceMsg msg = new InVoiceMsg(toUserName, fromUserName, createTime, msgType);
            msg.setMediaId(XmlKit.elementText(root, "MediaId"));
            msg.setFormat(XmlKit.elementText(root, "Format"));
            msg.setMsgId(XmlKit.elementText(root, "MsgId"));
            return msg;
        }
        InSpeechRecognitionResults msg = new InSpeechRecognitionResults(toUserName, fromUserName, createTime, msgType);
        msg.setMediaId(XmlKit.elementText(root, "MediaId"));
        msg.setFormat(XmlKit.elementText(root, "Format"));
        msg.setMsgId(XmlKit.elementText(root, "MsgId"));
        msg.setRecognition(recognition);
        return msg;
    }

    private static InMsg parseInVideoMsg(Element root, String toUserName, String fromUserName, Integer createTime, String msgType) {
        InVideoMsg msg = new InVideoMsg(toUserName, fromUserName, createTime, msgType);
        msg.setMediaId(XmlKit.elementText(root, "MediaId"));
        msg.setThumbMediaId(XmlKit.elementText(root, "ThumbMediaId"));
        msg.setMsgId(XmlKit.elementText(root, "MsgId"));
        return msg;
    }

    private static InMsg parseInShortVideoMsg(Element root, String toUserName, String fromUserName, Integer createTime, String msgType) {
        InShortVideoMsg msg = new InShortVideoMsg(toUserName, fromUserName, createTime, msgType);
        msg.setMediaId(XmlKit.elementText(root, "MediaId"));
        msg.setThumbMediaId(XmlKit.elementText(root, "ThumbMediaId"));
        msg.setMsgId(XmlKit.elementText(root, "MsgId"));
        return msg;
    }

    private static InMsg parseInLocationMsg(Element root, String toUserName, String fromUserName, Integer createTime, String msgType) {
        InLocationMsg msg = new InLocationMsg(toUserName, fromUserName, createTime, msgType);
        msg.setLocation_X(XmlKit.elementText(root, "Location_X"));
        msg.setLocation_Y(XmlKit.elementText(root, "Location_Y"));
        msg.setScale(XmlKit.elementText(root, "Scale"));
        msg.setLabel(XmlKit.elementText(root, "Label"));
        msg.setMsgId(XmlKit.elementText(root, "MsgId"));
        return msg;
    }

    private static InMsg parseInLinkMsg(Element root, String toUserName, String fromUserName, Integer createTime, String msgType) {
        InLinkMsg msg = new InLinkMsg(toUserName, fromUserName, createTime, msgType);
        msg.setTitle(XmlKit.elementText(root, "Title"));
        msg.setDescription(XmlKit.elementText(root, "Description"));
        msg.setUrl(XmlKit.elementText(root, "Url"));
        msg.setMsgId(XmlKit.elementText(root, "MsgId"));
        return msg;
    }

    private static InMsg parseInEvent(Element root, String toUserName, String fromUserName, Integer createTime, String msgType) {
        String event = XmlKit.elementText(root, "Event");
        String eventKey = XmlKit.elementText(root, "EventKey");
        if (("subscribe".equals(event) || "unsubscribe".equals(event)) && StrKit.isBlank((String)eventKey)) {
            return new InFollowEvent(toUserName, fromUserName, createTime, msgType, event);
        }
        String ticket = XmlKit.elementText(root, "Ticket");
        if ("subscribe".equals(event) && StrKit.notBlank((String)eventKey) && eventKey.startsWith("qrscene_")) {
            InQrCodeEvent e = new InQrCodeEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            e.setTicket(ticket);
            return e;
        }
        if ("SCAN".equals(event)) {
            InQrCodeEvent e = new InQrCodeEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            e.setTicket(ticket);
            return e;
        }
        if ("LOCATION".equals(event)) {
            InLocationEvent e = new InLocationEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setLatitude(XmlKit.elementText(root, "Latitude"));
            e.setLongitude(XmlKit.elementText(root, "Longitude"));
            e.setPrecision(XmlKit.elementText(root, "Precision"));
            return e;
        }
        if ("CLICK".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            return e;
        }
        if ("VIEW".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            return e;
        }
        if ("scancode_push".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            Document scanCodeInfo = XmlKit.element(root, "ScanCodeInfo");
            String scanType = XmlKit.documentText(scanCodeInfo, "ScanType");
            String scanResult = XmlKit.documentText(scanCodeInfo, "ScanResult");
            e.setScanCodeInfo(new ScanCodeInfo(scanType, scanResult));
            return e;
        }
        if ("scancode_waitmsg".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            Document scanCodeInfo = XmlKit.element(root, "ScanCodeInfo");
            String scanType = XmlKit.documentText(scanCodeInfo, "ScanType");
            String scanResult = XmlKit.documentText(scanCodeInfo, "ScanResult");
            e.setScanCodeInfo(new ScanCodeInfo(scanType, scanResult));
            return e;
        }
        if ("pic_sysphoto".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            return e;
        }
        if ("pic_photo_or_album".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            return e;
        }
        if ("pic_weixin".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            return e;
        }
        if ("location_select".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            return e;
        }
        if ("media_id".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            return e;
        }
        if ("view_limited".equals(event)) {
            InMenuEvent e = new InMenuEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setEventKey(eventKey);
            return e;
        }
        if ("TEMPLATESENDJOBFINISH".equals(event)) {
            InTemplateMsgEvent e = new InTemplateMsgEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setMsgId(XmlKit.elementText(root, "MsgID"));
            e.setStatus(XmlKit.elementText(root, "Status"));
            return e;
        }
        if ("MASSSENDJOBFINISH".equals(event)) {
            InMassEvent e = new InMassEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setMsgId(XmlKit.elementText(root, "MsgID"));
            e.setStatus(XmlKit.elementText(root, "Status"));
            e.setTotalCount(XmlKit.elementText(root, "TotalCount"));
            e.setFilterCount(XmlKit.elementText(root, "FilterCount"));
            e.setSentCount(XmlKit.elementText(root, "SentCount"));
            e.setErrorCount(XmlKit.elementText(root, "ErrorCount"));
            return e;
        }
        if ("kf_create_session".equals(event)) {
            InCustomEvent e = new InCustomEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setKfAccount(XmlKit.elementText(root, "KfAccount"));
            return e;
        }
        if ("kf_close_session".equals(event)) {
            InCustomEvent e = new InCustomEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setKfAccount(XmlKit.elementText(root, "KfAccount"));
            return e;
        }
        if ("kf_switch_session".equals(event)) {
            InCustomEvent e = new InCustomEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setKfAccount(XmlKit.elementText(root, "KfAccount"));
            e.setToKfAccount(XmlKit.elementText(root, "ToKfAccount"));
            return e;
        }
        if ("ShakearoundUserShake".equals(event)) {
            InShakearoundUserShakeEvent e = new InShakearoundUserShakeEvent(toUserName, fromUserName, createTime, msgType);
            e.setEvent(event);
            Document c = XmlKit.element(root, "ChosenBeacon");
            e.setUuid(XmlKit.documentText(c, "Uuid"));
            e.setMajor(Integer.parseInt(XmlKit.documentText(c, "Major")));
            e.setMinor(Integer.parseInt(XmlKit.documentText(c, "Minor")));
            e.setDistance(Float.valueOf(Float.parseFloat(XmlKit.documentText(c, "Distance"))));
            NodeList nodeList = root.getElementsByTagName("AroundBeacon");
            if (nodeList != null && nodeList.getLength() > 0) {
                InShakearoundUserShakeEvent.AroundBeacon aroundBeacon = null;
                ArrayList<InShakearoundUserShakeEvent.AroundBeacon> aroundBeacons = new ArrayList<InShakearoundUserShakeEvent.AroundBeacon>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Document nodeDoc = nodeList.item(i).getOwnerDocument();
                    aroundBeacon = new InShakearoundUserShakeEvent.AroundBeacon();
                    aroundBeacon.setUuid(XmlKit.documentText(nodeDoc, "Uuid"));
                    aroundBeacon.setMajor(Integer.parseInt(XmlKit.documentText(nodeDoc, "Major")));
                    aroundBeacon.setMinor(Integer.parseInt(XmlKit.documentText(nodeDoc, "Minor")));
                    aroundBeacon.setDistance(Float.valueOf(Float.parseFloat(XmlKit.documentText(nodeDoc, "Distance"))));
                    aroundBeacons.add(aroundBeacon);
                }
                e.setAroundBeaconList(aroundBeacons);
            }
            return e;
        }
        if ("qualification_verify_success".equals(event) || "naming_verify_success".equals(event) || "annual_renew".equals(event) || "verify_expired".equals(event)) {
            InVerifySuccessEvent e = new InVerifySuccessEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setExpiredTime(XmlKit.elementText(root, "expiredTime"));
            return e;
        }
        if ("qualification_verify_fail".equals(event) || "naming_verify_fail".equals(event)) {
            InVerifyFailEvent e = new InVerifyFailEvent(toUserName, fromUserName, createTime, msgType, event);
            e.setFailTime(XmlKit.elementText(root, "failTime"));
            e.setFailReason(XmlKit.elementText(root, "failReason"));
            return e;
        }
        if ("poi_check_notify".equals(event)) {
            InPoiCheckNotifyEvent e = new InPoiCheckNotifyEvent(toUserName, fromUserName, createTime, msgType);
            e.setUniqId(XmlKit.elementText(root, "UniqId"));
            e.setPoiId(XmlKit.elementText(root, "PoiId"));
            e.setResult(XmlKit.elementText(root, "Result"));
            e.setMsg(XmlKit.elementText(root, "Msg"));
            return e;
        }
        throw new RuntimeException("\u65e0\u6cd5\u8bc6\u522b\u7684\u4e8b\u4ef6\u7c7b\u578b" + event + "\uff0c\u8bf7\u67e5\u9605\u5fae\u4fe1\u516c\u4f17\u5e73\u53f0\u5f00\u53d1\u6587\u6863");
    }
}

