/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.msg;

import com.jfinal.weixin.sdk.msg.out.OutCustomMsg;
import com.jfinal.weixin.sdk.msg.out.OutImageMsg;
import com.jfinal.weixin.sdk.msg.out.OutMsg;
import com.jfinal.weixin.sdk.msg.out.OutMusicMsg;
import com.jfinal.weixin.sdk.msg.out.OutNewsMsg;
import com.jfinal.weixin.sdk.msg.out.OutTextMsg;
import com.jfinal.weixin.sdk.msg.out.OutVideoMsg;
import com.jfinal.weixin.sdk.msg.out.OutVoiceMsg;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.InvalidReferenceException;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;

public class OutMsgXmlBuilder {
    private static String encoding = "utf-8";
    private static Configuration config = OutMsgXmlBuilder.initFreeMarkerConfiguration();

    public static String build(OutMsg outMsg) {
        if (outMsg == null) {
            throw new IllegalArgumentException("\u53c2\u6570 OutMsg \u4e0d\u80fd\u4e3a null");
        }
        HashMap<String, OutMsg> root = new HashMap<String, OutMsg>();
        root.put("__msg", outMsg);
        try {
            Template template = config.getTemplate(outMsg.getClass().getSimpleName(), encoding);
            StringWriter sw = new StringWriter();
            template.process(root, (Writer)sw);
            return sw.toString();
        }
        catch (InvalidReferenceException e) {
            throw new RuntimeException("\u53ef\u80fd\u662f " + outMsg.getClass().getSimpleName() + " \u5bf9\u8c61\u4e2d\u7684\u67d0\u4e9b\u5c5e\u6027\u672a\u8d4b\u503c\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5", e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Configuration initFreeMarkerConfiguration() {
        Configuration config = new Configuration();
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        OutMsgXmlBuilder.initStringTemplateLoader(stringTemplateLoader);
        config.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        config.setTemplateUpdateDelay(999999);
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        config.setDefaultEncoding(encoding);
        config.setOutputEncoding(encoding);
        config.setLocale(Locale.getDefault());
        config.setLocalizedLookup(false);
        config.setNumberFormat("#0.#####");
        config.setDateFormat("yyyy-MM-dd");
        config.setTimeFormat("HH:mm:ss");
        config.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
        return config;
    }

    private static void initStringTemplateLoader(StringTemplateLoader loader) {
        loader.putTemplate(OutTextMsg.class.getSimpleName(), "<xml>\n<ToUserName><![CDATA[${__msg.toUserName}]]></ToUserName>\n<FromUserName><![CDATA[${__msg.fromUserName}]]></FromUserName>\n<CreateTime>${__msg.createTime}</CreateTime>\n<MsgType><![CDATA[${__msg.msgType}]]></MsgType>\n<Content><![CDATA[${__msg.content}]]></Content>\n</xml>");
        loader.putTemplate(OutNewsMsg.class.getSimpleName(), "<xml>\n<ToUserName><![CDATA[${__msg.toUserName}]]></ToUserName>\n<FromUserName><![CDATA[${__msg.fromUserName}]]></FromUserName>\n<CreateTime>${__msg.createTime}</CreateTime>\n<MsgType><![CDATA[${__msg.msgType}]]></MsgType>\n<ArticleCount>${__msg.getArticleCount()}</ArticleCount>\n<Articles>\n<#list __msg.getArticles() as x>\n<item>\n<Title><![CDATA[${(x.title)!}]]></Title>\n<Description><![CDATA[${(x.description)!}]]></Description>\n<PicUrl><![CDATA[${(x.picUrl)!}]]></PicUrl>\n<Url><![CDATA[${(x.url)!}]]></Url>\n</item>\n</#list>\n</Articles>\n</xml>");
        loader.putTemplate(OutImageMsg.class.getSimpleName(), "<xml>\n<ToUserName><![CDATA[${__msg.toUserName}]]></ToUserName>\n<FromUserName><![CDATA[${__msg.fromUserName}]]></FromUserName>\n<CreateTime>${__msg.createTime}</CreateTime>\n<MsgType><![CDATA[${__msg.msgType}]]></MsgType>\n<Image>\n<MediaId><![CDATA[${__msg.mediaId}]]></MediaId>\n</Image>\n</xml>");
        loader.putTemplate(OutVoiceMsg.class.getSimpleName(), "<xml>\n<ToUserName><![CDATA[${__msg.toUserName}]]></ToUserName>\n<FromUserName><![CDATA[${__msg.fromUserName}]]></FromUserName>\n<CreateTime>${__msg.createTime}</CreateTime>\n<MsgType><![CDATA[${__msg.msgType}]]></MsgType>\n<Voice>\n<MediaId><![CDATA[${__msg.mediaId}]]></MediaId>\n</Voice>\n</xml>");
        loader.putTemplate(OutVideoMsg.class.getSimpleName(), "<xml>\n<ToUserName><![CDATA[${__msg.toUserName}]]></ToUserName>\n<FromUserName><![CDATA[${__msg.fromUserName}]]></FromUserName>\n<CreateTime>${__msg.createTime}</CreateTime>\n<MsgType><![CDATA[${__msg.msgType}]]></MsgType>\n<Video>\n<MediaId><![CDATA[${__msg.mediaId}]]></MediaId>\n<Title><![CDATA[${(__msg.title)!}]]></Title>\n<Description><![CDATA[${(__msg.description)!}]]></Description>\n</Video>\n</xml>");
        loader.putTemplate(OutMusicMsg.class.getSimpleName(), "<xml>\n<ToUserName><![CDATA[${__msg.toUserName}]]></ToUserName>\n<FromUserName><![CDATA[${__msg.fromUserName}]]></FromUserName>\n<CreateTime>${__msg.createTime}</CreateTime>\n<MsgType><![CDATA[${__msg.msgType}]]></MsgType>\n<Music>\n<Title><![CDATA[${(__msg.title)!}]]></Title>\n<Description><![CDATA[${(__msg.description)!}]]></Description>\n<MusicUrl><![CDATA[${(__msg.musicUrl)!}]]></MusicUrl>\n<HQMusicUrl><![CDATA[${(__msg.hqMusicUrl)!}]]></HQMusicUrl>\n<FuncFlag>${__msg.funcFlag}</FuncFlag>\n</Music>\n</xml>");
        loader.putTemplate(OutCustomMsg.class.getSimpleName(), "<xml>\n<ToUserName><![CDATA[${__msg.toUserName}]]></ToUserName>\n<FromUserName><![CDATA[${__msg.fromUserName}]]></FromUserName>\n<CreateTime>${__msg.createTime}</CreateTime>\n<MsgType><![CDATA[${__msg.msgType}]]></MsgType>\n</xml>");
    }

    public static void setEncoding(String encoding) {
        OutMsgXmlBuilder.encoding = encoding;
    }

    public static String getEncoding() {
        return encoding;
    }
}

