/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.msg.out;

import com.jfinal.weixin.sdk.msg.in.InMsg;
import com.jfinal.weixin.sdk.msg.out.News;
import com.jfinal.weixin.sdk.msg.out.OutMsg;
import java.util.ArrayList;
import java.util.List;

public class OutNewsMsg
extends OutMsg {
    public static final String TEMPLATE = "<xml>\n<ToUserName><![CDATA[${__msg.toUserName}]]></ToUserName>\n<FromUserName><![CDATA[${__msg.fromUserName}]]></FromUserName>\n<CreateTime>${__msg.createTime}</CreateTime>\n<MsgType><![CDATA[${__msg.msgType}]]></MsgType>\n<ArticleCount>${__msg.getArticleCount()}</ArticleCount>\n<Articles>\n<#list __msg.getArticles() as x>\n<item>\n<Title><![CDATA[${(x.title)!}]]></Title>\n<Description><![CDATA[${(x.description)!}]]></Description>\n<PicUrl><![CDATA[${(x.picUrl)!}]]></PicUrl>\n<Url><![CDATA[${(x.url)!}]]></Url>\n</item>\n</#list>\n</Articles>\n</xml>";
    private List<News> articles = new ArrayList<News>();

    public OutNewsMsg() {
        this.msgType = "news";
    }

    public OutNewsMsg(InMsg inMsg) {
        super(inMsg);
        this.msgType = "news";
    }

    public Integer getArticleCount() {
        return this.articles.size();
    }

    public List<News> getArticles() {
        return this.articles;
    }

    public void setArticles(List<News> articles) {
        if (articles != null) {
            this.articles = articles;
        }
    }

    public OutNewsMsg addNews(List<News> articles) {
        if (articles != null) {
            this.articles.addAll(articles);
        }
        return this;
    }

    public OutNewsMsg addNews(String title, String description, String picUrl, String url) {
        this.articles.add(new News(title, description, picUrl, url));
        return this;
    }

    public OutNewsMsg addNews(News news) {
        this.articles.add(news);
        return this;
    }
}

