/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.utils;

import com.jfinal.kit.HttpKit;
import com.jfinal.kit.StrKit;
import com.jfinal.weixin.sdk.api.MediaFile;
import com.jfinal.weixin.sdk.utils.ClassUtils;
import com.jfinal.weixin.sdk.utils.HttpKitExt;
import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public final class HttpUtils {
    private static final HttpDelegate delegate;

    private HttpUtils() {
    }

    public static String get(String url) {
        return delegate.get(url);
    }

    public static String get(String url, Map<String, String> queryParas) {
        return delegate.get(url, queryParas);
    }

    public static String post(String url, String data) {
        return delegate.post(url, data);
    }

    public static String postSSL(String url, String data, String certPath, String certPass) {
        return delegate.postSSL(url, data, certPath, certPass);
    }

    public static MediaFile download(String url) {
        return delegate.download(url);
    }

    public static InputStream download(String url, String params) {
        return delegate.download(url, params);
    }

    public static String upload(String url, File file, String params) {
        return delegate.upload(url, file, params);
    }

    static {
        HttpDelegate delegateToUse = null;
        if (ClassUtils.isPresent("com.squareup.okhttp.OkHttpClient", HttpUtils.class.getClassLoader())) {
            delegateToUse = new OkHttpDelegate();
        } else if (ClassUtils.isPresent("com.jfinal.kit.HttpKit", HttpUtils.class.getClassLoader())) {
            delegateToUse = new HttpKitDelegate();
        }
        delegate = delegateToUse;
    }

    private static class HttpKitDelegate
    implements HttpDelegate {
        private HttpKitDelegate() {
        }

        @Override
        public String get(String url) {
            return HttpKit.get((String)url);
        }

        @Override
        public String get(String url, Map<String, String> queryParas) {
            return HttpKit.get((String)url, queryParas);
        }

        @Override
        public String post(String url, String data) {
            return HttpKit.post((String)url, (String)data);
        }

        @Override
        public String postSSL(String url, String data, String certPath, String certPass) {
            return HttpKitExt.postSSL(url, data, certPath, certPass);
        }

        @Override
        public MediaFile download(String url) {
            try {
                return HttpKitExt.download(url);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputStream download(String url, String params) {
            try {
                return HttpKitExt.downloadMaterial(url, params);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String upload(String url, File file, String params) {
            try {
                return HttpKitExt.uploadMedia(url, file, params);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class OkHttpDelegate
    implements HttpDelegate {
        OkHttpClient httpClient = new OkHttpClient();
        OkHttpClient httpsClient = this.httpClient.clone();
        Lock lock = new ReentrantLock();
        public static final MediaType CONTENT_TYPE_FORM = MediaType.parse((String)"application/x-www-form-urlencoded");

        private OkHttpDelegate() {
        }

        private String base(Request request) {
            try {
                Response response = this.httpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                return response.body().string();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String get(String url) {
            Request request = new Request.Builder().url(url).get().build();
            return this.base(request);
        }

        @Override
        public String get(String url, Map<String, String> queryParas) {
            HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
            for (Map.Entry<String, String> entry : queryParas.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
            HttpUrl httpUrl = urlBuilder.build();
            Request request = new Request.Builder().url(httpUrl).get().build();
            return this.base(request);
        }

        @Override
        public String post(String url, String params) {
            RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)params);
            Request request = new Request.Builder().url(url).post(body).build();
            return this.base(request);
        }

        @Override
        public String postSSL(String url, String data, String certPath, String certPass) {
            RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)data);
            Request request = new Request.Builder().url(url).post(body).build();
            try {
                KeyStore clientStore = KeyStore.getInstance("PKCS12");
                clientStore.load(new FileInputStream(certPath), certPass.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(clientStore, certPass.toCharArray());
                KeyManager[] kms = kmf.getKeyManagers();
                SSLContext sslContext = SSLContext.getInstance("TLSv1");
                sslContext.init(kms, null, new SecureRandom());
                this.lock.lock();
                this.httpsClient.setSslSocketFactory(sslContext.getSocketFactory());
                Response response = this.httpsClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                String string = response.body().string();
                return string;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public MediaFile download(String url) {
            Request request = new Request.Builder().url(url).get().build();
            try {
                Response response = this.httpsClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                ResponseBody body = response.body();
                MediaType mediaType = body.contentType();
                MediaFile mediaFile = new MediaFile();
                if (mediaType.type().equals("text")) {
                    mediaFile.setError(body.string());
                } else {
                    BufferedInputStream bis = new BufferedInputStream(body.byteStream());
                    String ds = response.header("Content-disposition");
                    String fullName = ds.substring(ds.indexOf("filename=\"") + 10, ds.length() - 1);
                    String relName = fullName.substring(0, fullName.lastIndexOf("."));
                    String suffix = fullName.substring(relName.length() + 1);
                    mediaFile.setFullName(fullName);
                    mediaFile.setFileName(relName);
                    mediaFile.setSuffix(suffix);
                    mediaFile.setContentLength(body.contentLength() + "");
                    mediaFile.setContentType(body.contentType().toString());
                    mediaFile.setFileStream(bis);
                }
                return mediaFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputStream download(String url, String params) {
            Request request;
            if (StrKit.notBlank((String)params)) {
                RequestBody body = RequestBody.create((MediaType)CONTENT_TYPE_FORM, (String)params);
                request = new Request.Builder().url(url).post(body).build();
            } else {
                request = new Request.Builder().url(url).get().build();
            }
            try {
                Response response = this.httpsClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Unexpected code " + response);
                }
                return response.body().byteStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String upload(String url, File file, String params) {
            RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
            MultipartBuilder builder = new MultipartBuilder().type(MultipartBuilder.FORM).addFormDataPart("media", file.getName(), fileBody);
            if (StrKit.notBlank((String)params)) {
                builder.addFormDataPart("description", params);
            }
            RequestBody requestBody = builder.build();
            Request request = new Request.Builder().url(url).post(requestBody).build();
            return this.base(request);
        }
    }

    private static interface HttpDelegate {
        public String get(String var1);

        public String get(String var1, Map<String, String> var2);

        public String post(String var1, String var2);

        public String postSSL(String var1, String var2, String var3, String var4);

        public MediaFile download(String var1);

        public InputStream download(String var1, String var2);

        public String upload(String var1, File var2, String var3);
    }
}

