/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class IOUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toString(InputStream input) throws IOException {
        int n;
        StringBuffer out = new StringBuffer();
        byte[] b = new byte[4096];
        while ((n = input.read(b)) != -1) {
            out.append(new String(b, 0, n));
        }
        IOUtils.closeQuietly(input);
        return out.toString();
    }

    public static void toFile(InputStream input, File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        int bytesRead = 0;
        byte[] buffer = new byte[4096];
        while ((bytesRead = input.read(buffer, 0, 4096)) != -1) {
            ((OutputStream)os).write(buffer, 0, bytesRead);
        }
        IOUtils.closeQuietly(os);
        IOUtils.closeQuietly(input);
    }
}

