/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.utils;

import com.jfinal.log.Log;
import java.util.concurrent.Callable;

public class RetryUtils {
    private static Log log = Log.getLog(RetryUtils.class);

    public static <V extends ResultCheck> V retryOnException(int retryLimit, Callable<V> retryCallable) {
        ResultCheck v = null;
        for (int i = 0; i < retryLimit; ++i) {
            block3: {
                try {
                    v = (ResultCheck)retryCallable.call();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn("retry on " + (i + 1) + " times v = " + (v == null ? null : v.getJson()), (Throwable)e);
                }
            }
            if (v.matching()) break;
            log.error("retry on " + (i + 1) + " times but not matching v = " + (v == null ? null : v.getJson()));
        }
        return (V)v;
    }

    public static <V extends ResultCheck> V retryOnException(int retryLimit, long sleepMillis, Callable<V> retryCallable) throws InterruptedException {
        ResultCheck v = null;
        for (int i = 0; i < retryLimit; ++i) {
            block3: {
                try {
                    v = (ResultCheck)retryCallable.call();
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn("retry on " + (i + 1) + " times v = " + (v == null ? null : v.getJson()), (Throwable)e);
                }
            }
            if (v.matching()) break;
            log.error("retry on " + (i + 1) + " times but not matching v = " + (v == null ? null : v.getJson()));
        }
        return (V)v;
    }

    public static interface ResultCheck {
        public boolean matching();

        public String getJson();
    }
}

