/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.iot.api;

import com.jfinal.kit.Kv;
import com.jfinal.weixin.iot.api.DeviceAuth;
import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.util.List;

public class DeviceApi {
    private static final String TransMsgUrl = "https://api.weixin.qq.com/device/transmsg?access_token=ACCESS_TOKEN";
    private static final String AuthorizeUrl = "https://api.weixin.qq.com/device/authorize_device?access_token=ACCESS_TOKEN";
    private static final String CreateQrcode = "https://api.weixin.qq.com/device/create_qrcode?access_token=ACCESS_TOKEN";
    private static final String CreateQrcodeNew = "https://api.weixin.qq.com/device/getqrcode?access_token=ACCESS_TOKEN&product_id=PRODUCT_ID";
    private static final String GetStatUrl = "https://api.weixin.qq.com/device/get_stat?access_token=ACCESS_TOKEN&device_id=DEVICE_ID";
    private static final String VerifyQrcodeUrl = "https://api.weixin.qq.com/device/verify_qrcode?access_token=ACCESS_TOKEN";
    private static final String GetOpenidUrl = "https://api.weixin.qq.com/device/get_openid?access_token=ACCESS_TOKEN&device_type=DEVICE_TYPE&device_id=DEVICE_ID";
    private static final String bindUrl = "https://api.weixin.qq.com/device/bind?access_token=ACCESS_TOKEN";
    private static final String unbindUrl = "https://api.weixin.qq.com/device/unbind?access_token=ACCESS_TOKEN";
    private static final String compelbindUrl = "https://api.weixin.qq.com/device/compel_bind?access_token=ACCESS_TOKEN";

    public static ApiResult transMsg(String deviceType, String deviceID, String openID, String content) {
        Kv data = Kv.by((Object)"device_type", (Object)deviceType);
        data.set((Object)"device_id", (Object)deviceID);
        data.set((Object)"open_id", (Object)openID);
        data.set((Object)"content", (Object)content);
        String url = TransMsgUrl.replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        return new ApiResult(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult createQrcode(List<String> deviceIds) {
        Kv data = Kv.by((Object)"device_num", (Object)deviceIds.size());
        data.set((Object)"device_id_list", deviceIds);
        String url = CreateQrcode.replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        return new ApiResult(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult createQrcodeNew(String productId) {
        String url = CreateQrcodeNew.replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr()).replace("PRODUCT_ID", productId);
        return new ApiResult(HttpUtils.get(url));
    }

    public static ApiResult bind(String tikect, String deviceid, String openid) {
        Kv data = Kv.by((Object)"ticket", (Object)tikect);
        data.set((Object)"device_id", (Object)deviceid);
        data.set((Object)"openid", (Object)openid);
        String url = bindUrl.replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        return new ApiResult(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult compelBind(String deviceid, String openid) {
        Kv data = Kv.by((Object)"device_id", (Object)deviceid);
        data.set((Object)"openid", (Object)openid);
        String url = compelbindUrl.replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        return new ApiResult(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult unbind(String tikect, String deviceid, String openid) {
        Kv data = Kv.by((Object)"ticket", (Object)tikect);
        data.set((Object)"device_id", (Object)deviceid);
        data.set((Object)"openid", (Object)openid);
        String url = unbindUrl.replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        return new ApiResult(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult authorize(List<DeviceAuth> devices, boolean isCreate, String productId) {
        Kv data = Kv.by((Object)"device_num", (Object)String.valueOf(devices.size()));
        data.set((Object)"op_type", (Object)(isCreate ? "0" : "1"));
        data.set((Object)"product_id", (Object)productId);
        data.set((Object)"device_list", devices);
        String url = AuthorizeUrl.replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        System.out.println(JsonUtils.toJson(data));
        return new ApiResult(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult getStat(String deviceId) {
        String url = GetStatUrl.replace("DEVICE_ID", deviceId).replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        return new ApiResult(HttpUtils.get(url));
    }

    public static ApiResult verifyQrcode(String ticket) {
        Kv data = Kv.by((Object)"ticket", (Object)ticket);
        String url = VerifyQrcodeUrl.replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        return new ApiResult(HttpUtils.post(url, JsonUtils.toJson(data)));
    }

    public static ApiResult getOpenId(String deviceType, String deviceId) {
        String url = GetOpenidUrl.replace("DEVICE_TYPE", deviceType).replace("DEVICE_ID", deviceId).replace("ACCESS_TOKEN", AccessTokenApi.getAccessTokenStr());
        return new ApiResult(HttpUtils.get(url));
    }
}

