/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.api;

import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.kit.ParaMap;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import com.jfinal.wxaapp.api.WxaAccessTokenApi;
import java.util.HashMap;
import java.util.Map;

public class WxaMessageApi {
    private static String customMessageUrl = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=";

    private static ApiResult sendMsg(Map<String, Object> message) {
        String accessToken = WxaAccessTokenApi.getAccessTokenStr();
        String jsonResult = HttpUtils.post(customMessageUrl + accessToken, JsonUtils.toJson(message));
        return new ApiResult(jsonResult);
    }

    public static ApiResult sendText(String openId, String text) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "text");
        HashMap<String, String> textObj = new HashMap<String, String>();
        textObj.put("content", text);
        json.put("text", textObj);
        return WxaMessageApi.sendMsg(json);
    }

    public static ApiResult sendImage(String openId, String mediaId) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "image");
        HashMap<String, String> image = new HashMap<String, String>();
        image.put("media_id", mediaId);
        json.put("image", image);
        return WxaMessageApi.sendMsg(json);
    }

    public static ApiResult sendLink(String openId, String title, String description, String url, String thumbUrl) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "link");
        json.put("link", ParaMap.create().put("title", title).put("description", description).put("url", url).put("thumb_url", thumbUrl).getData());
        return WxaMessageApi.sendMsg(json);
    }

    public static ApiResult sendMiniProgramPage(String openId, String title, String pagePath, String thumbMediaId) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("touser", openId);
        json.put("msgtype", "miniprogrampage");
        json.put("miniprogrampage", ParaMap.create().put("title", title).put("pagepath", pagePath).put("thumb_media_id", thumbMediaId).getData());
        return WxaMessageApi.sendMsg(json);
    }
}

