/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.javacompat.network;

import com.linkedin.norbert.javacompat.cluster.Node;
import com.linkedin.norbert.javacompat.network.Endpoint;
import com.linkedin.norbert.javacompat.network.HashFunction;
import com.linkedin.norbert.javacompat.network.PartitionedLoadBalancer;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;

public class ConsistentHashPartitionedLoadBalancer<PartitionedId>
implements PartitionedLoadBalancer<PartitionedId> {
    private final HashFunction<String> _hashFunction;
    private final Map<Integer, NavigableMap<Long, Endpoint>> _rings;
    private final TreeMap<Long, Map<Endpoint, Set<Integer>>> _routingMap;

    public ConsistentHashPartitionedLoadBalancer(HashFunction<String> hashFunction, Map<Integer, NavigableMap<Long, Endpoint>> map, TreeMap<Long, Map<Endpoint, Set<Integer>>> treeMap, PartitionedLoadBalancer<PartitionedId> partitionedLoadBalancer) {
        this._hashFunction = hashFunction;
        this._rings = map;
        this._routingMap = treeMap;
    }

    /*
     * WARNING - void declaration
     */
    public static <PartitionedId> ConsistentHashPartitionedLoadBalancer<PartitionedId> build(int n, HashFunction<String> hashFunction, Set<Endpoint> set, PartitionedLoadBalancer<PartitionedId> partitionedLoadBalancer) {
        void var8_14;
        Object object;
        Number number2;
        TreeMap<Long, Map<Endpoint, Set<Integer>>> treeMap;
        TreeMap<Integer, HashSet<Endpoint>> treeMap2 = new TreeMap<Integer, HashSet<Endpoint>>();
        for (Endpoint object22 : set) {
            treeMap = object22.getNode();
            for (Number number2 : treeMap.getPartitionIds()) {
                object = (Set)treeMap2.get(number2);
                if (object == null) {
                    object = new HashSet<Endpoint>();
                    treeMap2.put((Integer)number2, (HashSet<Endpoint>)object);
                }
                object.add(object22);
            }
        }
        int n2 = 0;
        TreeMap<Integer, NavigableMap<Long, Endpoint>> treeMap3 = new TreeMap<Integer, NavigableMap<Long, Endpoint>>();
        for (Map.Entry entry : treeMap2.entrySet()) {
            number2 = (Integer)entry.getKey();
            object = new TreeMap();
            if (n2 < ((Set)entry.getValue()).size()) {
                n2 = ((Set)entry.getValue()).size();
            }
            for (Endpoint endpoint : (Set)entry.getValue()) {
                for (int i = 0; i < n; ++i) {
                    object.put(hashFunction.hash(String.format("node-%d-%d", endpoint.getNode().getId(), i)), endpoint);
                }
            }
            treeMap3.put((Integer)number2, (NavigableMap<Long, Endpoint>)object);
        }
        treeMap = new TreeMap<Long, Map<Endpoint, Set<Integer>>>();
        boolean bl = false;
        while (var8_14 < n * n2) {
            number2 = hashFunction.hash(String.format("ring-%d", (int)var8_14));
            object = new HashMap();
            for (Map.Entry entry : treeMap3.entrySet()) {
                Integer n3 = (Integer)entry.getKey();
                NavigableMap navigableMap = (NavigableMap)entry.getValue();
                Endpoint endpoint = (Endpoint)ConsistentHashPartitionedLoadBalancer.lookup(navigableMap, number2).getValue();
                HashSet<Integer> hashSet = (HashSet<Integer>)object.get(endpoint);
                if (hashSet == null) {
                    hashSet = new HashSet<Integer>();
                }
                hashSet.add(n3);
                object.put(endpoint, hashSet);
            }
            treeMap.put((Long)number2, (Map<Endpoint, Set<Integer>>)object);
            ++var8_14;
        }
        return new ConsistentHashPartitionedLoadBalancer<PartitionedId>(hashFunction, treeMap3, treeMap, partitionedLoadBalancer);
    }

    @Override
    public Node nextNode(PartitionedId PartitionedId, Long l) {
        return this.nextNode(PartitionedId, l, 0L);
    }

    @Override
    public Node nextNode(PartitionedId PartitionedId) {
        return this.nextNode(PartitionedId, 0L, 0L);
    }

    @Override
    public Node nextNode(PartitionedId PartitionedId, Long l, Long l2) {
        long l3 = this._hashFunction.hash(PartitionedId.toString());
        long l4 = (int)(Math.abs(l3) % (long)this._rings.size());
        NavigableMap<Long, Endpoint> navigableMap = this._rings.get(l4);
        Endpoint endpoint = ConsistentHashPartitionedLoadBalancer.searchWheel(navigableMap, l3, new Function<Endpoint, Boolean>(){

            @Override
            public Boolean apply(Endpoint endpoint) {
                return endpoint.canServeRequests();
            }
        });
        return endpoint.getNode();
    }

    @Override
    public Set<Node> nodesForPartitionedId(PartitionedId PartitionedId) {
        return this.nodesForPartitionedId(PartitionedId, 0L, 0L);
    }

    @Override
    public Set<Node> nodesForPartitionedId(PartitionedId PartitionedId, Long l) {
        return this.nodesForPartitionedId(PartitionedId, l, 0L);
    }

    @Override
    public Set<Node> nodesForPartitionedId(PartitionedId PartitionedId, Long l, Long l2) {
        return this.nodesForOneReplica(PartitionedId, l, l2).keySet();
    }

    @Override
    public Map<Node, Set<Integer>> nodesForOneReplica(PartitionedId PartitionedId) {
        return this.nodesForOneReplica(PartitionedId, 0L, 0L);
    }

    @Override
    public Map<Node, Set<Integer>> nodesForOneReplica(PartitionedId PartitionedId, Long l) {
        return this.nodesForOneReplica(PartitionedId, l, 0L);
    }

    @Override
    public Map<Node, Set<Integer>> nodesForOneReplica(PartitionedId PartitionedId, Long l, Long l2) {
        Set set;
        Map<Endpoint, Set<Integer>> map = ConsistentHashPartitionedLoadBalancer.lookup(this._routingMap, this._hashFunction.hash(PartitionedId.toString())).getValue();
        HashMap<Node, Set<Integer>> hashMap = new HashMap<Node, Set<Integer>>();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Map.Entry<Endpoint, Set<Integer>> object : map.entrySet()) {
            Node node = object.getKey().getNode();
            set = object.getValue();
            if (object.getKey().canServeRequests()) {
                hashMap.put(node, new HashSet<Integer>(set));
                continue;
            }
            hashSet.addAll(set);
        }
        if (hashSet.size() > 0) {
            Map<Node, Set<Integer>> map2 = this.nodesForPartitions(PartitionedId, hashSet);
            for (Map.Entry entry : map2.entrySet()) {
                set = (Set)hashMap.get(entry.getKey());
                if (set != null) {
                    set.addAll((Collection)entry.getValue());
                    continue;
                }
                hashMap.put((Node)entry.getKey(), (Set<Integer>)entry.getValue());
            }
        }
        return hashMap;
    }

    @Override
    public Map<Node, Set<Integer>> nodesForPartitions(PartitionedId PartitionedId, Set<Integer> set) {
        return this.nodesForPartitions(PartitionedId, set, 0L, 0L);
    }

    @Override
    public Map<Node, Set<Integer>> nodesForPartitions(PartitionedId PartitionedId, Set<Integer> set, Long l) {
        return this.nodesForPartitions(PartitionedId, set, l, 0L);
    }

    @Override
    public Map<Node, Set<Integer>> nodesForPartitions(PartitionedId PartitionedId, Set<Integer> set, Long l, Long l2) {
        HashMap<Node, Set<Integer>> hashMap = new HashMap<Node, Set<Integer>>();
        for (int n : set) {
            NavigableMap<Long, Endpoint> navigableMap = this._rings.get(n);
            Endpoint endpoint = ConsistentHashPartitionedLoadBalancer.searchWheel(navigableMap, this._hashFunction.hash(PartitionedId.toString()), new Function<Endpoint, Boolean>(){

                @Override
                public Boolean apply(Endpoint endpoint) {
                    return endpoint.canServeRequests();
                }
            });
            Node node = endpoint.getNode();
            HashSet<Integer> hashSet = (HashSet<Integer>)hashMap.get(node);
            if (hashSet == null) {
                hashSet = new HashSet<Integer>();
            }
            hashSet.add(n);
            hashMap.put(node, hashSet);
        }
        return hashMap;
    }

    private static <K, V> V searchWheel(NavigableMap<K, V> navigableMap, K k, Function<V, Boolean> function) {
        Map.Entry<K, V> entry;
        if (navigableMap.isEmpty()) {
            return null;
        }
        Map.Entry<K, V> entry2 = entry = ConsistentHashPartitionedLoadBalancer.lookup(navigableMap, k);
        do {
            if (!function.apply(entry2.getValue()).booleanValue()) continue;
            return entry2.getValue();
        } while ((entry2 = ConsistentHashPartitionedLoadBalancer.rotateWheel(navigableMap, entry2.getKey())) != entry);
        return entry2.getValue();
    }

    private static <K, V> Map.Entry<K, V> rotateWheel(NavigableMap<K, V> navigableMap, K k) {
        Map.Entry<K, V> entry = navigableMap.higherEntry(k);
        if (entry == null) {
            return navigableMap.firstEntry();
        }
        return entry;
    }

    private static <K, V> Map.Entry<K, V> lookup(NavigableMap<K, V> navigableMap, K k) {
        Object v = navigableMap.get(k);
        if (v == null) {
            Map.Entry<K, V> entry = navigableMap.ceilingEntry(k);
            if (entry == null) {
                return navigableMap.firstEntry();
            }
            return entry;
        }
        return new AbstractMap.SimpleEntry(k, v);
    }

    public static interface Function<K, V> {
        public V apply(K var1);
    }
}

