/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.javacompat.network;

import com.linkedin.norbert.cluster.InvalidClusterException;
import com.linkedin.norbert.javacompat.network.ConsistentHashPartitionedLoadBalancer;
import com.linkedin.norbert.javacompat.network.Endpoint;
import com.linkedin.norbert.javacompat.network.HashFunction;
import com.linkedin.norbert.javacompat.network.PartitionedLoadBalancer;
import com.linkedin.norbert.javacompat.network.PartitionedLoadBalancerFactory;
import java.util.HashSet;
import java.util.Set;

public class ConsistentHashPartitionedLoadBalancerFactory<PartitionedId>
implements PartitionedLoadBalancerFactory<PartitionedId> {
    private final int _bucketCount;
    private final HashFunction<String> _hashFunction;
    private final PartitionedLoadBalancerFactory<PartitionedId> _fallThrough;

    public ConsistentHashPartitionedLoadBalancerFactory(int n) {
        this(n, new HashFunction.MD5HashFunction(), null);
    }

    public ConsistentHashPartitionedLoadBalancerFactory(int n, PartitionedLoadBalancerFactory<PartitionedId> partitionedLoadBalancerFactory) {
        this(n, new HashFunction.MD5HashFunction(), partitionedLoadBalancerFactory);
    }

    public ConsistentHashPartitionedLoadBalancerFactory(int n, HashFunction<String> hashFunction, PartitionedLoadBalancerFactory<PartitionedId> partitionedLoadBalancerFactory) {
        this._bucketCount = n;
        this._hashFunction = hashFunction;
        this._fallThrough = partitionedLoadBalancerFactory;
    }

    @Override
    public PartitionedLoadBalancer<PartitionedId> newLoadBalancer(Set<Endpoint> set) throws InvalidClusterException {
        return ConsistentHashPartitionedLoadBalancer.build(this._bucketCount, this._hashFunction, set, null);
    }

    @Override
    public Integer getNumPartitions(Set<Endpoint> set) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Endpoint endpoint : set) {
            hashSet.addAll(endpoint.getNode().getPartitionIds());
        }
        return hashSet.size();
    }
}

