/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.javacompat.network;

import java.nio.charset.Charset;
import java.security.MessageDigest;

public interface HashFunction<V> {
    public long hash(V var1);

    public static class FNVStringHashingStrategy
    implements HashFunction<String> {
        public static final long FNV1_64_INIT = -3750763034362895579L;
        private static final long FNV_64_PRIME = 1099511628211L;

        @Override
        public long hash(String string) {
            long l = -3750763034362895579L;
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                l *= 1099511628211L;
                l ^= (long)string.charAt(i);
            }
            return l;
        }
    }

    public static class NativeObjectHashFunction<V>
    implements HashFunction<V> {
        @Override
        public long hash(V v) {
            return v.hashCode();
        }
    }

    public static class MD5HashFunction
    implements HashFunction<String> {
        private static Charset Utf8 = Charset.forName("UTF-8");

        @Override
        public long hash(String string) {
            MessageDigest messageDigest;
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage(), exception);
            }
            byte[] byArray = messageDigest.digest(string.getBytes(Utf8));
            long l = (long)(byArray[3] & 0xFF) << 24 | (long)(byArray[2] & 0xFF) << 16 | (long)(byArray[1] & 0xFF) << 8 | (long)(byArray[0] & 0xFF);
            return Math.abs(l);
        }
    }
}

