/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.javacompat.network;

import com.linkedin.norbert.javacompat.cluster.Node;
import com.linkedin.norbert.javacompat.cluster.ZooKeeperClusterClient;
import com.linkedin.norbert.javacompat.network.NettyNetworkClient;
import com.linkedin.norbert.javacompat.network.NetworkClientConfig;
import com.linkedin.norbert.javacompat.network.Ping;
import com.linkedin.norbert.javacompat.network.PingSerializer;
import com.linkedin.norbert.javacompat.network.RoundRobinLoadBalancerFactory;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Log4JLoggerFactory;

public class NorbertJavaNetworkClientMain {
    public static void main(String[] stringArray) {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        ZooKeeperClusterClient zooKeeperClusterClient = new ZooKeeperClusterClient(null, stringArray[0], stringArray[1], 30000);
        NetworkClientConfig networkClientConfig = new NetworkClientConfig();
        networkClientConfig.setClusterClient(zooKeeperClusterClient);
        NettyNetworkClient nettyNetworkClient = new NettyNetworkClient(networkClientConfig, new RoundRobinLoadBalancerFactory());
        Node node = zooKeeperClusterClient.getNodeWithId(1);
        Future<Ping> future = nettyNetworkClient.sendRequestToNode(new Ping(System.currentTimeMillis()), node, new PingSerializer());
        try {
            Ping ping = future.get(750L, TimeUnit.MILLISECONDS);
            System.out.println(String.format("Ping took %dms", System.currentTimeMillis() - ping.timestamp));
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        zooKeeperClusterClient.shutdown();
    }
}

