/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.javacompat.network;

import com.linkedin.norbert.javacompat.network.NettyNetworkServer;
import com.linkedin.norbert.javacompat.network.NetworkServerConfig;
import com.linkedin.norbert.javacompat.network.Ping;
import com.linkedin.norbert.javacompat.network.PingSerializer;
import com.linkedin.norbert.javacompat.network.RequestHandler;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Log4JLoggerFactory;

public class NorbertJavaNetworkServerMain {
    public static void main(String[] stringArray) {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Log4JLoggerFactory());
        NetworkServerConfig networkServerConfig = new NetworkServerConfig();
        networkServerConfig.setServiceName(stringArray[0]);
        networkServerConfig.setZooKeeperConnectString(stringArray[1]);
        networkServerConfig.setZooKeeperSessionTimeoutMillis(30000);
        final NettyNetworkServer nettyNetworkServer = new NettyNetworkServer(networkServerConfig);
        nettyNetworkServer.registerHandler(new PingHandler(), new PingSerializer());
        nettyNetworkServer.bind(Integer.parseInt(stringArray[2]));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                nettyNetworkServer.shutdown();
            }
        });
    }

    private static class PingHandler
    implements RequestHandler<Ping, Ping> {
        private PingHandler() {
        }

        @Override
        public Ping handleRequest(Ping ping) throws Exception {
            System.out.printf("Requested ping from client %d milliseconds ago (assuming synchronized clocks)", ping.timestamp - System.currentTimeMillis());
            return new Ping(System.currentTimeMillis());
        }
    }
}

