/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.javacompat.network;

import com.linkedin.norbert.javacompat.cluster.Node;
import com.linkedin.norbert.javacompat.network.Endpoint;
import com.linkedin.norbert.javacompat.network.HashFunction;
import com.linkedin.norbert.javacompat.network.PartitionedLoadBalancer;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RingHashPartitionedLoadBalancer
implements PartitionedLoadBalancer<Integer> {
    public static final Logger log = Logger.getLogger(RingHashPartitionedLoadBalancer.class);
    private final TreeMap<Long, Endpoint> nodeCircleMap = new TreeMap();
    private final HashFunction<String> hashStrategy;

    RingHashPartitionedLoadBalancer(int n, Set<Endpoint> set, HashFunction<String> hashFunction) {
        this.hashStrategy = hashFunction;
        for (Endpoint endpoint : set) {
            Node node = endpoint.getNode();
            Set<Integer> set2 = node.getPartitionIds();
            for (Integer n2 : set2) {
                for (int i = 0; i < n; ++i) {
                    String string = node.getId() + ":" + n2 + ":" + i + ":" + node.getUrl();
                    this.nodeCircleMap.put(hashFunction.hash(string), endpoint);
                }
            }
        }
    }

    @Override
    public Node nextNode(Integer n) {
        return this.nextNode(n, (Long)0L, (Long)0L);
    }

    @Override
    public Node nextNode(Integer n, Long l) {
        return this.nextNode(n, l, (Long)0L);
    }

    @Override
    public Node nextNode(Integer n, Long l, Long l2) {
        Map.Entry<Long, Endpoint> entry;
        Endpoint endpoint;
        if (this.nodeCircleMap.isEmpty()) {
            return null;
        }
        Long l3 = this.hashStrategy.hash(n.toString());
        l3 = (l3 = this.nodeCircleMap.ceilingKey(l3)) == null ? this.nodeCircleMap.firstKey() : l3;
        Endpoint endpoint2 = endpoint = this.nodeCircleMap.get(l3);
        do {
            Node node = endpoint2.getNode();
            if (endpoint2.canServeRequests() && node.isCapableOf(l, l2)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(n + " is sent to node " + node.getId()));
                }
                return node;
            }
            entry = this.nodeCircleMap.higherEntry(l3);
            entry = entry == null ? this.nodeCircleMap.firstEntry() : entry;
            l3 = entry.getKey();
        } while ((endpoint2 = entry.getValue()) != endpoint);
        log.warn((Object)"All endpoints seem unavailable! Using the default");
        return endpoint.getNode();
    }

    @Override
    public Set<Node> nodesForPartitionedId(Integer n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Node> nodesForPartitionedId(Integer n, Long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Node> nodesForPartitionedId(Integer n, Long l, Long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Node, Set<Integer>> nodesForOneReplica(Integer n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Node, Set<Integer>> nodesForOneReplica(Integer n, Long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Node, Set<Integer>> nodesForOneReplica(Integer n, Long l, Long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Node, Set<Integer>> nodesForPartitions(Integer n, Set<Integer> set) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Node, Set<Integer>> nodesForPartitions(Integer n, Set<Integer> set, Long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<Node, Set<Integer>> nodesForPartitions(Integer n, Set<Integer> set, Long l, Long l2) {
        throw new UnsupportedOperationException();
    }
}

