/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.javacompat.network;

import com.linkedin.norbert.cluster.InvalidClusterException;
import com.linkedin.norbert.javacompat.network.Endpoint;
import com.linkedin.norbert.javacompat.network.HashFunction;
import com.linkedin.norbert.javacompat.network.PartitionedLoadBalancer;
import com.linkedin.norbert.javacompat.network.PartitionedLoadBalancerFactory;
import com.linkedin.norbert.javacompat.network.RingHashPartitionedLoadBalancer;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class RingHashPartitionedLoadBalancerFactory
implements PartitionedLoadBalancerFactory<Integer> {
    public static final Logger log = Logger.getLogger(RingHashPartitionedLoadBalancerFactory.class);
    private final int _numberOfReplicas;
    private final HashFunction<String> _hashingStrategy;

    public RingHashPartitionedLoadBalancerFactory(int n, HashFunction<String> hashFunction) {
        this._numberOfReplicas = n;
        this._hashingStrategy = hashFunction;
    }

    public RingHashPartitionedLoadBalancerFactory(int n) {
        this(n, new HashFunction.MD5HashFunction());
    }

    @Override
    public PartitionedLoadBalancer<Integer> newLoadBalancer(Set<Endpoint> set) throws InvalidClusterException {
        return new RingHashPartitionedLoadBalancer(this._numberOfReplicas, set, this._hashingStrategy);
    }

    @Override
    public Integer getNumPartitions(Set<Endpoint> set) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Endpoint endpoint : set) {
            hashSet.addAll(endpoint.getNode().getPartitionIds());
        }
        return hashSet.size();
    }

    private static final double mean(int[] nArray) {
        double d = 0.0;
        for (int n : nArray) {
            d += (double)n;
        }
        return d / (double)nArray.length;
    }

    private static final double variance(int[] nArray) {
        long l = 0L;
        double d = 0.0;
        double d2 = 0.0;
        for (int n : nArray) {
            double d3 = (double)n - d;
            d2 += d3 * ((double)n - (d += d3 / (double)(++l)));
        }
        return d2 / (double)l;
    }

    private static final double standard_deviation(int[] nArray) {
        return Math.sqrt(RingHashPartitionedLoadBalancerFactory.variance(nArray));
    }
}

