/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.javacompat.network;

import com.linkedin.norbert.cluster.InvalidClusterException;
import com.linkedin.norbert.javacompat.cluster.ClusterListener;
import com.linkedin.norbert.javacompat.cluster.Node;
import com.linkedin.norbert.javacompat.cluster.ZooKeeperClusterClient;
import com.linkedin.norbert.javacompat.network.Endpoint;
import com.linkedin.norbert.javacompat.network.LoadBalancer;
import com.linkedin.norbert.javacompat.network.LoadBalancerFactory;
import com.linkedin.norbert.javacompat.network.NettyNetworkClient;
import com.linkedin.norbert.javacompat.network.NettyNetworkServer;
import com.linkedin.norbert.javacompat.network.NetworkClientConfig;
import com.linkedin.norbert.javacompat.network.NetworkServerConfig;
import com.linkedin.norbert.javacompat.network.Ping;
import com.linkedin.norbert.javacompat.network.PingSerializer;
import com.linkedin.norbert.javacompat.network.RequestHandler;
import com.linkedin.norbert.javacompat.network.RoundRobinLoadBalancerFactory;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class RunNorbertSetup {
    public static void main(String[] stringArray) {
        RunNorbertSetup.configCluster("norbert", "localhost:2181");
        RunNorbertSetup.startServer("norbert", 1, "localhost:2181");
        RunNorbertSetup.startServer("norbert", 2, "localhost:2181");
        NetworkClientConfig networkClientConfig = new NetworkClientConfig();
        networkClientConfig.setServiceName("norbert");
        networkClientConfig.setZooKeeperConnectString("localhost:2181");
        networkClientConfig.setZooKeeperSessionTimeoutMillis(30000);
        networkClientConfig.setConnectTimeoutMillis(1000);
        networkClientConfig.setWriteTimeoutMillis(150);
        networkClientConfig.setMaxConnectionsPerNode(5);
        networkClientConfig.setStaleRequestTimeoutMins(10);
        networkClientConfig.setStaleRequestCleanupFrequencyMins(10);
        LoadBalancerFactory loadBalancerFactory = new LoadBalancerFactory(){

            @Override
            public LoadBalancer newLoadBalancer(final Set<Endpoint> set) throws InvalidClusterException {
                return new LoadBalancer(){

                    @Override
                    public Node nextNode() {
                        return ((Endpoint)set.iterator().next()).getNode();
                    }

                    @Override
                    public Node nextNode(Long l) {
                        return ((Endpoint)set.iterator().next()).getNode();
                    }

                    @Override
                    public Node nextNode(Long l, Long l2) {
                        return ((Endpoint)set.iterator().next()).getNode();
                    }
                };
            }
        };
        NettyNetworkClient nettyNetworkClient = new NettyNetworkClient(networkClientConfig, new RoundRobinLoadBalancerFactory());
        Ping ping = new Ping(System.currentTimeMillis());
        Future<Ping> future = nettyNetworkClient.sendRequest(ping, new PingSerializer());
        try {
            Ping ping2 = future.get();
            System.out.println("got ping resp: " + ping2);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
        }
    }

    private static void startServer(String string, int n, String string2) {
        NetworkServerConfig networkServerConfig = new NetworkServerConfig();
        networkServerConfig.setServiceName(string);
        networkServerConfig.setZooKeeperConnectString(string2);
        networkServerConfig.setZooKeeperSessionTimeoutMillis(30000);
        networkServerConfig.setRequestThreadCorePoolSize(5);
        networkServerConfig.setRequestThreadMaxPoolSize(10);
        networkServerConfig.setRequestThreadKeepAliveTimeSecs(300);
        NettyNetworkServer nettyNetworkServer = new NettyNetworkServer(networkServerConfig);
        nettyNetworkServer.registerHandler(new RequestHandler<Ping, Ping>(){

            @Override
            public Ping handleRequest(Ping ping) throws Exception {
                return new Ping(System.currentTimeMillis());
            }
        }, new PingSerializer());
        nettyNetworkServer.bind(n);
    }

    private static void configCluster(String string, String string2) {
        final ZooKeeperClusterClient zooKeeperClusterClient = new ZooKeeperClusterClient(string, string2, 30000);
        zooKeeperClusterClient.awaitConnectionUninterruptibly();
        zooKeeperClusterClient.addListener(new ClusterListener(){

            @Override
            public void handleClusterConnected(Set<Node> set) {
                System.out.println("connected to cluster: " + set);
            }

            @Override
            public void handleClusterNodesChanged(Set<Node> set) {
                System.out.println("nodes changed: ");
                for (Node node : set) {
                    System.out.println("node: " + node);
                }
            }

            @Override
            public void handleClusterDisconnected() {
                Set<Node> set = zooKeeperClusterClient.getNodes();
                System.out.println("dis-connected from cluster: " + set);
            }

            @Override
            public void handleClusterShutdown() {
                Set<Node> set = zooKeeperClusterClient.getNodes();
                System.out.println("cluster shutdown: " + set);
            }
        });
        zooKeeperClusterClient.removeNode(1);
        zooKeeperClusterClient.removeNode(2);
        zooKeeperClusterClient.addNode(1, "localhost:5002");
        zooKeeperClusterClient.addNode(2, "localhost:5003");
    }
}

