/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.network;

import scala.ScalaObject;

public final class NetworkDefaults$
implements ScalaObject {
    public static final NetworkDefaults$ MODULE$;
    private final int MAX_CONNECTIONS_PER_NODE;
    private final int CONNECT_TIMEOUT_MILLIS;
    private final int WRITE_TIMEOUT_MILLIS;
    private final int STALE_REQUEST_CLEANUP_FREQUENCY_MINS;
    private final int STALE_REQUEST_TIMEOUT_MINS;
    private final long CLOSE_CHANNEL_TIMEOUT_MILLIS;
    private final long REQUEST_TIMEOUT_MILLIS;
    private final int REQUEST_THREAD_CORE_POOL_SIZE;
    private final int REQUEST_THREAD_MAX_POOL_SIZE;
    private final int REQUEST_THREAD_KEEP_ALIVE_TIME_SECS;
    private final int REQUEST_THREAD_POOL_QUEUE_SIZE;
    private final int RESPONSE_THREAD_CORE_POOL_SIZE;
    private final int RESPONSE_THREAD_MAX_POOL_SIZE;
    private final int RESPONSE_THREAD_KEEP_ALIVE_TIME_SECS;
    private final int RESPONSE_THREAD_POOL_QUEUE_SIZE;
    private final long REQUEST_STATISTICS_WINDOW;
    private final double OUTLIER_MULTIPLIER;
    private final double OUTLIER_CONSTANT;
    private final boolean AVOID_BYTESTRING_COPY;

    static {
        new NetworkDefaults$();
    }

    public int MAX_CONNECTIONS_PER_NODE() {
        return this.MAX_CONNECTIONS_PER_NODE;
    }

    public int CONNECT_TIMEOUT_MILLIS() {
        return this.CONNECT_TIMEOUT_MILLIS;
    }

    public int WRITE_TIMEOUT_MILLIS() {
        return this.WRITE_TIMEOUT_MILLIS;
    }

    public int STALE_REQUEST_CLEANUP_FREQUENCY_MINS() {
        return this.STALE_REQUEST_CLEANUP_FREQUENCY_MINS;
    }

    public int STALE_REQUEST_TIMEOUT_MINS() {
        return this.STALE_REQUEST_TIMEOUT_MINS;
    }

    public long CLOSE_CHANNEL_TIMEOUT_MILLIS() {
        return this.CLOSE_CHANNEL_TIMEOUT_MILLIS;
    }

    public long REQUEST_TIMEOUT_MILLIS() {
        return this.REQUEST_TIMEOUT_MILLIS;
    }

    public int REQUEST_THREAD_CORE_POOL_SIZE() {
        return this.REQUEST_THREAD_CORE_POOL_SIZE;
    }

    public int REQUEST_THREAD_MAX_POOL_SIZE() {
        return this.REQUEST_THREAD_MAX_POOL_SIZE;
    }

    public int REQUEST_THREAD_KEEP_ALIVE_TIME_SECS() {
        return this.REQUEST_THREAD_KEEP_ALIVE_TIME_SECS;
    }

    public int REQUEST_THREAD_POOL_QUEUE_SIZE() {
        return this.REQUEST_THREAD_POOL_QUEUE_SIZE;
    }

    public int RESPONSE_THREAD_CORE_POOL_SIZE() {
        return this.RESPONSE_THREAD_CORE_POOL_SIZE;
    }

    public int RESPONSE_THREAD_MAX_POOL_SIZE() {
        return this.RESPONSE_THREAD_MAX_POOL_SIZE;
    }

    public int RESPONSE_THREAD_KEEP_ALIVE_TIME_SECS() {
        return this.RESPONSE_THREAD_KEEP_ALIVE_TIME_SECS;
    }

    public int RESPONSE_THREAD_POOL_QUEUE_SIZE() {
        return this.RESPONSE_THREAD_POOL_QUEUE_SIZE;
    }

    public long REQUEST_STATISTICS_WINDOW() {
        return this.REQUEST_STATISTICS_WINDOW;
    }

    public double OUTLIER_MULTIPLIER() {
        return this.OUTLIER_MULTIPLIER;
    }

    public double OUTLIER_CONSTANT() {
        return this.OUTLIER_CONSTANT;
    }

    public boolean AVOID_BYTESTRING_COPY() {
        return this.AVOID_BYTESTRING_COPY;
    }

    private NetworkDefaults$() {
        MODULE$ = this;
        this.MAX_CONNECTIONS_PER_NODE = 5;
        this.CONNECT_TIMEOUT_MILLIS = 1000;
        this.WRITE_TIMEOUT_MILLIS = 150;
        this.STALE_REQUEST_CLEANUP_FREQUENCY_MINS = 1;
        this.STALE_REQUEST_TIMEOUT_MINS = 1;
        this.CLOSE_CHANNEL_TIMEOUT_MILLIS = 30000L;
        this.REQUEST_TIMEOUT_MILLIS = 30000L;
        this.REQUEST_THREAD_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
        this.REQUEST_THREAD_MAX_POOL_SIZE = this.REQUEST_THREAD_CORE_POOL_SIZE() * 5;
        this.REQUEST_THREAD_KEEP_ALIVE_TIME_SECS = 300;
        this.REQUEST_THREAD_POOL_QUEUE_SIZE = 5000;
        this.RESPONSE_THREAD_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 1;
        this.RESPONSE_THREAD_MAX_POOL_SIZE = this.REQUEST_THREAD_CORE_POOL_SIZE() * 5;
        this.RESPONSE_THREAD_KEEP_ALIVE_TIME_SECS = 100;
        this.RESPONSE_THREAD_POOL_QUEUE_SIZE = 5000;
        this.REQUEST_STATISTICS_WINDOW = 10000L;
        this.OUTLIER_MULTIPLIER = 2.0;
        this.OUTLIER_CONSTANT = 10.0;
        this.AVOID_BYTESTRING_COPY = true;
    }
}

