/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.network.client;

import com.linkedin.norbert.cluster.ClusterClientComponent;
import com.linkedin.norbert.cluster.InvalidClusterException;
import com.linkedin.norbert.cluster.Node;
import com.linkedin.norbert.logging.Logging;
import com.linkedin.norbert.network.InputSerializer;
import com.linkedin.norbert.network.OutputSerializer;
import com.linkedin.norbert.network.Request;
import com.linkedin.norbert.network.Request$;
import com.linkedin.norbert.network.RequestAccess;
import com.linkedin.norbert.network.client.NetworkClient;
import com.linkedin.norbert.network.client.NetworkClient$;
import com.linkedin.norbert.network.client.loadbalancer.LoadBalancerFactoryComponent;
import com.linkedin.norbert.network.common.BaseNetworkClient;
import com.linkedin.norbert.network.common.Endpoint;
import com.linkedin.norbert.network.common.FutureAdapter;
import java.util.concurrent.Future;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Left;
import scala.None$;
import scala.Option;
import scala.Right;
import scala.Some;
import scala.collection.immutable.Set;

public abstract class NetworkClient$class {
    public static void sendRequest(ClusterClientComponent $this, Object request, Function1 callback, InputSerializer is, OutputSerializer os) {
        ((NetworkClient)((Object)$this)).sendRequest(request, callback, (Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, is, os);
    }

    public static void sendRequest(ClusterClientComponent $this, Object request, Function1 callback, Option capability, InputSerializer is, OutputSerializer os) {
        ((NetworkClient)((Object)$this)).sendRequest(request, callback, (Option<Long>)capability, (Option<Long>)None$.MODULE$, is, os);
    }

    public static void sendRequest(ClusterClientComponent $this, Object request$2, Function1 callback$2, Option capability$2, Option persistentCapability$2, InputSerializer is$2, OutputSerializer os$2) {
        ((BaseNetworkClient)((Object)$this)).doIfConnected(new NetworkClient$.anonfun.sendRequest.1($this, request$2, callback$2, capability$2, persistentCapability$2, is$2, os$2));
    }

    public static Future sendRequest(ClusterClientComponent $this, Object request, InputSerializer is, OutputSerializer os) {
        return ((NetworkClient)((Object)$this)).sendRequest(request, (Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, is, os);
    }

    public static Future sendRequest(ClusterClientComponent $this, Object request, Option capability, InputSerializer is, OutputSerializer os) {
        return ((NetworkClient)((Object)$this)).sendRequest(request, (Option<Long>)capability, (Option<Long>)None$.MODULE$, is, os);
    }

    public static Future sendRequest(ClusterClientComponent $this, Object request, Option capability, Option persistentCapability, InputSerializer is, OutputSerializer os) {
        FutureAdapter future = new FutureAdapter();
        ((NetworkClient)((Object)$this)).sendRequest(request, future, (Option<Long>)capability, (Option<Long>)persistentCapability, is, os);
        return future;
    }

    public static void sendRequest(ClusterClientComponent $this, Object request, Function1 callback, int maxRetry, InputSerializer is, OutputSerializer os) {
        ((NetworkClient)((Object)$this)).sendRequest(request, callback, maxRetry, (Option<Long>)None$.MODULE$, (Option<Long>)None$.MODULE$, is, os);
    }

    public static void sendRequest(ClusterClientComponent $this, Object request, Function1 callback, int maxRetry, Option capability, InputSerializer is, OutputSerializer os) {
        ((NetworkClient)((Object)$this)).sendRequest(request, callback, maxRetry, (Option<Long>)capability, (Option<Long>)None$.MODULE$, is, os);
    }

    public static void sendRequest(ClusterClientComponent $this, Object request$1, Function1 callback$1, int maxRetry$1, Option capability$1, Option persistentCapability$1, InputSerializer is$1, OutputSerializer os$1) {
        ((BaseNetworkClient)((Object)$this)).doIfConnected(new NetworkClient$.anonfun.sendRequest.2($this, request$1, callback$1, maxRetry$1, capability$1, persistentCapability$1, is$1, os$1));
    }

    public static void sendMessage(ClusterClientComponent $this, Object request$3, InputSerializer is$4, OutputSerializer os$4) {
        ((BaseNetworkClient)((Object)$this)).doIfConnected(new NetworkClient$.anonfun.sendMessage.1($this, request$3, is$4, os$4));
    }

    public static void sendMessage(ClusterClientComponent $this, Object request$5, Option capability$5, InputSerializer is$6, OutputSerializer os$6) {
        ((BaseNetworkClient)((Object)$this)).doIfConnected(new NetworkClient$.anonfun.sendMessage.2($this, request$5, capability$5, is$6, os$6));
    }

    public static void sendMessage(ClusterClientComponent $this, Object request$4, Option capability$4, Option persistentCapability$4, InputSerializer is$5, OutputSerializer os$5) {
        ((BaseNetworkClient)((Object)$this)).doIfConnected(new NetworkClient$.anonfun.sendMessage.3($this, request$4, capability$4, persistentCapability$4, is$5, os$5));
    }

    public static void retryCallback(ClusterClientComponent $this, Function1 underlying$1, int maxRetry$2, Option capability$3, Option persistentCapability$3, Either res, InputSerializer is$3, OutputSerializer os$3) {
        if (underlying$1 == null) {
            throw new NullPointerException();
        }
        if (maxRetry$2 <= 0) {
            res.fold((Function1)new NetworkClient$.anonfun.retryCallback.1($this, underlying$1, maxRetry$2, capability$3, persistentCapability$3, is$3, os$3), (Function1)new NetworkClient$.anonfun.retryCallback.2($this, underlying$1));
        } else {
            res.fold((Function1)new NetworkClient$.anonfun.retryCallback.3($this, underlying$1, maxRetry$2, capability$3, persistentCapability$3, is$3, os$3), (Function1)new NetworkClient$.anonfun.retryCallback.4($this, underlying$1));
        }
    }

    public static void updateLoadBalancer(ClusterClientComponent $this, Set nodes$1) {
        ((NetworkClient)((Object)$this)).com$linkedin$norbert$network$client$NetworkClient$$loadBalancer_$eq((Option)(nodes$1 != null && nodes$1.size() > 0 ? NetworkClient$class.liftedTree1$1($this, nodes$1) : None$.MODULE$));
    }

    private static final void propagate$1(ClusterClientComponent $this, Throwable t, Function1 function1) {
        function1.apply((Object)new Left((Object)t));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void handleFailure$1(ClusterClientComponent $this, Throwable t$1, Function1 function1, int n, Option option, Option option2, InputSerializer inputSerializer, OutputSerializer outputSerializer) {
        Throwable throwable = t$1;
        if (throwable instanceof Throwable && throwable instanceof RequestAccess) {
            Throwable throwable2;
            Throwable ra$1 = throwable2 = throwable;
            ((Logging)((Object)$this)).log().info((Function0<String>)new NetworkClient$.anonfun.handleFailure.1.1($this, t$1, ra$1));
            Request request$6 = (Request)((RequestAccess)((Object)ra$1)).request();
            if (request$6.retryAttempt() >= n) {
                NetworkClient$class.propagate$1($this, t$1, function1);
                return;
            }
            try {
                Node node = (Node)((Either)((NetworkClient)((Object)$this)).com$linkedin$norbert$network$client$NetworkClient$$loadBalancer().getOrElse((Function0)new NetworkClient$.anonfun.7($this))).fold((Function1)new NetworkClient$.anonfun.8($this), (Function1)new NetworkClient$.anonfun.9($this, option, option2, request$6));
                if (node.equals(request$6.node())) {
                    NetworkClient$class.propagate$1($this, t$1, function1);
                    return;
                }
                Request request1$1 = Request$.MODULE$.apply(request$6.message(), node, inputSerializer, outputSerializer, new Some((Object)new NetworkClient$.anonfun.10($this, function1, n, option, option2, inputSerializer, outputSerializer)), request$6.retryAttempt() + 1);
                ((Logging)((Object)$this)).log().debug((Function0<String>)new NetworkClient$.anonfun.handleFailure.1.2($this, request1$1));
                ((BaseNetworkClient)((Object)$this)).doSendRequest(request1$1, inputSerializer, outputSerializer);
                return;
            }
            catch (Throwable throwable3) {
                NetworkClient$class.propagate$1($this, t$1, function1);
                return;
            }
        } else {
            NetworkClient$class.propagate$1($this, t$1, function1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Option liftedTree1$1(ClusterClientComponent $this, Set set) {
        void var2_2;
        Some exceptionResult1 = null;
        try {
            exceptionResult1 = new Some((Object)new Right((Object)((LoadBalancerFactoryComponent)((Object)$this)).loadBalancerFactory().newLoadBalancer((Set<Endpoint>)set)));
        }
        catch (Exception exception) {
            String msg$1 = "Exception while creating new router instance";
            ((Logging)((Object)$this)).log().error(exception, (Function0<String>)new NetworkClient$.anonfun.liftedTree1.1.2($this, msg$1));
            exceptionResult1 = new Some((Object)new Left((Object)new InvalidClusterException(msg$1, exception)));
        }
        catch (InvalidClusterException invalidClusterException) {
            ((Logging)((Object)$this)).log().info(invalidClusterException, (Function0<String>)new NetworkClient$.anonfun.liftedTree1.1.1($this));
            exceptionResult1 = new Some((Object)new Left((Object)invalidClusterException));
        }
        return var2_2;
    }

    public static void $init$(ClusterClientComponent $this) {
        ((NetworkClient)((Object)$this)).com$linkedin$norbert$network$client$NetworkClient$$loadBalancer_$eq((Option)None$.MODULE$);
    }
}

