/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.network.common;

import com.linkedin.norbert.cluster.ClusterClientComponent;
import com.linkedin.norbert.cluster.ClusterDisconnectedException;
import com.linkedin.norbert.cluster.ClusterShutdownException;
import com.linkedin.norbert.cluster.Node;
import com.linkedin.norbert.logging.Logging;
import com.linkedin.norbert.network.InputSerializer;
import com.linkedin.norbert.network.NetworkNotStartedException;
import com.linkedin.norbert.network.NetworkShutdownException;
import com.linkedin.norbert.network.OutputSerializer;
import com.linkedin.norbert.network.Request;
import com.linkedin.norbert.network.ResponseIterator;
import com.linkedin.norbert.network.common.BaseNetworkClient;
import com.linkedin.norbert.network.common.BaseNetworkClient$;
import com.linkedin.norbert.network.common.BaseNetworkClient$$anonfun$com$linkedin$norbert$network$common$BaseNetworkClient$;
import com.linkedin.norbert.network.common.ClusterIoClientComponent;
import com.linkedin.norbert.network.common.Endpoint;
import com.linkedin.norbert.network.common.FutureAdapter;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;

public abstract class BaseNetworkClient$class {
    public static void start(ClusterClientComponent $this) {
        if (((BaseNetworkClient)((Object)$this)).startedSwitch().compareAndSet(false, true)) {
            ((Logging)((Object)$this)).log().debug((Function0<String>)new BaseNetworkClient$.anonfun.start.1($this));
            $this.clusterClient().start();
            $this.clusterClient().awaitConnectionUninterruptibly();
            BaseNetworkClient$class.com$linkedin$norbert$network$common$BaseNetworkClient$$updateCurrentState((ClusterClientComponent)((Object)((BaseNetworkClient)((Object)$this))), $this.clusterClient().nodes());
            ((BaseNetworkClient)((Object)$this)).currentlyConnected_$eq($this.clusterClient().isConnected());
            ((BaseNetworkClient)((Object)$this)).previouslyConnected_$eq(((BaseNetworkClient)((Object)$this)).currentlyConnected());
            ((BaseNetworkClient)((Object)$this)).com$linkedin$norbert$network$common$BaseNetworkClient$$listenerKey_$eq($this.clusterClient().addListener(new BaseNetworkClient$.anon.1($this)));
        }
    }

    public static void sendRequestToNode(ClusterClientComponent $this, Object request$1, Node node$1, Function1 callback$1, InputSerializer is$1, OutputSerializer os$1) {
        ((BaseNetworkClient)((Object)$this)).doIfConnected(new BaseNetworkClient$.anonfun.sendRequestToNode.1($this, request$1, node$1, callback$1, is$1, os$1));
    }

    public static Future sendRequestToNode(ClusterClientComponent $this, Object request, Node node, InputSerializer is, OutputSerializer os) {
        FutureAdapter future = new FutureAdapter();
        ((BaseNetworkClient)((Object)$this)).sendRequestToNode(request, node, future, is, os);
        return future;
    }

    public static ResponseIterator broadcastMessage(ClusterClientComponent $this, Object request$2, InputSerializer is$2, OutputSerializer os$2) {
        return (ResponseIterator)((BaseNetworkClient)((Object)$this)).doIfConnected(new BaseNetworkClient$.anonfun.broadcastMessage.1($this, request$2, is$2, os$2));
    }

    public static void shutdown(ClusterClientComponent $this) {
        BaseNetworkClient$class.com$linkedin$norbert$network$common$BaseNetworkClient$$doShutdown((ClusterClientComponent)((Object)((BaseNetworkClient)((Object)$this))), false);
    }

    public static void addFilters(ClusterClientComponent $this, List clientFilters) {
        ((BaseNetworkClient)((Object)$this)).com$linkedin$norbert$network$common$BaseNetworkClient$$filters_$eq(clientFilters);
    }

    public static void doSendRequest(ClusterClientComponent $this, Request requestCtx$1, InputSerializer is, OutputSerializer os) {
        ((BaseNetworkClient)((Object)$this)).com$linkedin$norbert$network$common$BaseNetworkClient$$filters().foreach((Function1)new BaseNetworkClient$.anonfun.doSendRequest.1($this, requestCtx$1));
        ((ClusterIoClientComponent)((Object)$this)).clusterIoClient().sendMessage(requestCtx$1.node(), requestCtx$1);
    }

    public static Object doIfConnected(ClusterClientComponent $this, Function0 block) {
        if (((BaseNetworkClient)((Object)$this)).shutdownSwitch().get()) {
            throw new NetworkShutdownException();
        }
        if (((BaseNetworkClient)((Object)$this)).startedSwitch().get()) {
            if (((BaseNetworkClient)((Object)$this)).previouslyConnected()) {
                return block.apply();
            }
            throw new ClusterDisconnectedException();
        }
        throw new NetworkNotStartedException();
    }

    public static final void com$linkedin$norbert$network$common$BaseNetworkClient$$updateCurrentState(ClusterClientComponent $this, Set nodes2) {
        ((BaseNetworkClient)((Object)$this)).currentNodes_$eq((Set<Node>)nodes2);
        ((BaseNetworkClient)((Object)$this)).endpoints_$eq(((ClusterIoClientComponent)((Object)$this)).clusterIoClient().nodesChanged((Set<Node>)nodes2));
        ((BaseNetworkClient)((Object)$this)).updateLoadBalancer(((BaseNetworkClient)((Object)$this)).endpoints());
    }

    public static final void com$linkedin$norbert$network$common$BaseNetworkClient$$doShutdown(ClusterClientComponent $this, boolean fromCluster) {
        if (((BaseNetworkClient)((Object)$this)).shutdownSwitch().compareAndSet(false, true) && ((BaseNetworkClient)((Object)$this)).startedSwitch().get()) {
            ((Logging)((Object)$this)).log().info((Function0<String>)new BaseNetworkClient$$anonfun$com$linkedin$norbert$network$common$BaseNetworkClient$.doShutdown.1($this));
            if (!fromCluster) {
                ((Logging)((Object)$this)).log().debug((Function0<String>)new BaseNetworkClient$$anonfun$com$linkedin$norbert$network$common$BaseNetworkClient$.doShutdown.2($this));
                try {
                    $this.clusterClient().removeListener(((BaseNetworkClient)((Object)$this)).com$linkedin$norbert$network$common$BaseNetworkClient$$listenerKey());
                }
                catch (ClusterShutdownException clusterShutdownException) {
                    // empty catch block
                }
            }
            ((Logging)((Object)$this)).log().debug((Function0<String>)new BaseNetworkClient$$anonfun$com$linkedin$norbert$network$common$BaseNetworkClient$.doShutdown.3($this));
            ((ClusterIoClientComponent)((Object)$this)).clusterIoClient().shutdown();
            ((Logging)((Object)$this)).log().info((Function0<String>)new BaseNetworkClient$$anonfun$com$linkedin$norbert$network$common$BaseNetworkClient$.doShutdown.4($this));
        }
    }

    public static void $init$(ClusterClientComponent $this) {
        ((BaseNetworkClient)((Object)$this)).currentNodes_$eq((Set<Node>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]))));
        ((BaseNetworkClient)((Object)$this)).endpoints_$eq((Set<Endpoint>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Endpoint[0]))));
        ((BaseNetworkClient)((Object)$this)).currentlyConnected_$eq(false);
        ((BaseNetworkClient)((Object)$this)).previouslyConnected_$eq(false);
        ((BaseNetworkClient)((Object)$this)).com$linkedin$norbert$network$common$BaseNetworkClient$_setter_$startedSwitch_$eq(new AtomicBoolean());
        ((BaseNetworkClient)((Object)$this)).com$linkedin$norbert$network$common$BaseNetworkClient$_setter_$shutdownSwitch_$eq(new AtomicBoolean());
        ((BaseNetworkClient)((Object)$this)).com$linkedin$norbert$network$common$BaseNetworkClient$$filters_$eq(List$.MODULE$.empty());
    }
}

