/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.network.common;

import com.linkedin.norbert.network.common.SimpleBackoff$;
import com.linkedin.norbert.norbertutils.Clock;
import java.util.concurrent.atomic.AtomicLong;
import scala.ScalaObject;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y4\u0011\"\u0001\u0002\u0005\u0002\u0003\u0005\tA\u0001\u0007\u0003\u001bMKW\u000e\u001d7f\u0005\u0006\u001c7n\u001c4g\u0015\t\u0019A!\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0019\tqA\\3uo>\u00148N\u0003\u0002\b\u0011\u00059an\u001c:cKJ$(BA\u0005\u000b\u0003!a\u0017N\\6fI&t'\"A\u0006\u0002\u0007\r|WnE\u0002\u0001\u001bU\u0001\"AD\n\u000e\u0003=Q!\u0001E\t\u0002\t1\fgn\u001a\u0006\u0002%\u0005!!.\u0019<b\u0013\t!rB\u0001\u0004PE*,7\r\u001e\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000f\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0015\u0019Gn\\2l\u0007\u0001\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0004\u0002\u00199|'OY3siV$\u0018\u000e\\:\n\u0005\r\u0002#!B\"m_\u000e\\\u0007\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u001d5LgNQ1dW>4g\rV5nKB\u0011acJ\u0005\u0003Q]\u0011A\u0001T8oO\"A!\u0006\u0001B\u0001B\u0003%a%\u0001\bnCb\u0014\u0015mY6pM\u001a$\u0016.\\3\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\u0011q\u0003'\r\u001a\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000bqY\u0003\u0019\u0001\u0010\t\u000f\u0015Z\u0003\u0013!a\u0001M!9!f\u000bI\u0001\u0002\u00041\u0003b\u0002\u001b\u0001\u0001\u0004%\t!N\u0001\nY\u0006\u001cH/\u0012:s_J,\u0012A\n\u0005\bo\u0001\u0001\r\u0011\"\u00019\u00035a\u0017m\u001d;FeJ|'o\u0018\u0013fcR\u0011\u0011\b\u0010\t\u0003-iJ!aO\f\u0003\tUs\u0017\u000e\u001e\u0005\b{Y\n\t\u00111\u0001'\u0003\rAH%\r\u0005\u0007\u007f\u0001\u0001\u000b\u0015\u0002\u0014\u0002\u00151\f7\u000f^#se>\u0014\b\u0005\u000b\u0002?\u0003B\u0011aCQ\u0005\u0003\u0007^\u0011\u0001B^8mCRLG.\u001a\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0003-\u0019WO\u001d:CC\u000e\\wN\u001a4\u0016\u0003\u001d\u0003\"\u0001S(\u000e\u0003%S!AS&\u0002\r\u0005$x.\\5d\u0015\taU*\u0001\u0006d_:\u001cWO\u001d:f]RT!AT\t\u0002\tU$\u0018\u000e\\\u0005\u0003!&\u0013!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019\u0011\u0006\u0001)A\u0005\u000f\u0006a1-\u001e:s\u0005\u0006\u001c7n\u001c4gA!)A\u000b\u0001C\u0001+\u0006ian\u001c;jMf4\u0015-\u001b7ve\u0016,\u0012!\u000f\u0005\u0006/\u0002!I!V\u0001\u0011S:\u001c'/Z7f]R\u0014\u0015mY6pM\u001aDQ!\u0017\u0001\u0005\nU\u000b1\u0003\u001e:z\t\u0016\u001c'/Z7f]R\u0014\u0015mY6pM\u001aDQa\u0017\u0001\u0005\u0002q\u000b\u0011\"\u0019<bS2\f'\r\\3\u0016\u0003u\u0003\"A\u00060\n\u0005};\"a\u0002\"p_2,\u0017M\\\u0004\tC\n\t\t\u0011#\u0002\u0003E\u0006i1+[7qY\u0016\u0014\u0015mY6pM\u001a\u0004\"aL2\u0007\u0013\u0005\u0011A1!A\t\u0006\t!7cA2\u000e+!)Af\u0019C\u0001MR\t!\rC\u0004iGF\u0005I\u0011A5\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\t!N\u000b\u0002'W.\nA\u000e\u0005\u0002ne6\taN\u0003\u0002pa\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003c^\t!\"\u00198o_R\fG/[8o\u0013\t\u0019hNA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq!^2\u0012\u0002\u0013\u0005\u0011.\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001a")
public class SimpleBackoff
implements ScalaObject {
    private final Clock clock;
    private final long minBackoffTime;
    private final long maxBackoffTime;
    private volatile long lastError;
    private final AtomicLong currBackoff;

    public static final long init$default$3() {
        return SimpleBackoff$.MODULE$.init$default$3();
    }

    public static final long init$default$2() {
        return SimpleBackoff$.MODULE$.init$default$2();
    }

    public long lastError() {
        return this.lastError;
    }

    public void lastError_$eq(long l) {
        this.lastError = l;
    }

    public AtomicLong currBackoff() {
        return this.currBackoff;
    }

    public void notifyFailure() {
        if (this.clock.getCurrentTimeMilliseconds() - this.lastError() >= this.minBackoffTime) {
            this.incrementBackoff();
        }
    }

    private void incrementBackoff() {
        this.lastError_$eq(this.clock.getCurrentTimeMilliseconds());
        long currentBackoffTime = this.currBackoff().get();
        long newBackoffTime = package$.MODULE$.max(this.minBackoffTime, package$.MODULE$.min(2L * currentBackoffTime, this.maxBackoffTime));
        this.currBackoff().compareAndSet(currentBackoffTime, newBackoffTime);
    }

    private void tryDecrementBackoff() {
        long now = this.clock.getCurrentTimeMilliseconds();
        long currentBackoffTime = this.currBackoff().get();
        if (currentBackoffTime != 0L && now - this.lastError() > 3L * this.maxBackoffTime) {
            this.currBackoff().compareAndSet(currentBackoffTime, 0L);
        }
    }

    public boolean available() {
        long now = this.clock.getCurrentTimeMilliseconds();
        this.tryDecrementBackoff();
        return now - this.lastError() > this.currBackoff().get();
    }

    public SimpleBackoff(Clock clock, long minBackoffTime, long maxBackoffTime) {
        this.clock = clock;
        this.minBackoffTime = minBackoffTime;
        this.maxBackoffTime = maxBackoffTime;
        this.lastError = 0L;
        this.currBackoff = new AtomicLong(0L);
    }
}

