/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.network.netty;

import com.linkedin.norbert.jmx.JMX$;
import com.linkedin.norbert.logging.Logger;
import com.linkedin.norbert.logging.Logging;
import com.linkedin.norbert.logging.Logging$class;
import com.linkedin.norbert.network.Request;
import com.linkedin.norbert.network.client.ResponseHandler;
import com.linkedin.norbert.network.common.CachedNetworkStatistics;
import com.linkedin.norbert.network.common.CachedNetworkStatistics$;
import com.linkedin.norbert.network.common.CanServeRequestStrategy;
import com.linkedin.norbert.network.common.CompositeCanServeRequestStrategy;
import com.linkedin.norbert.network.common.NetworkClientStatisticsMBeanImpl;
import com.linkedin.norbert.network.common.ServerErrorStrategyMBeanImpl;
import com.linkedin.norbert.network.common.SimpleBackoffStrategy;
import com.linkedin.norbert.network.common.SimpleBackoffStrategy$;
import com.linkedin.norbert.network.netty.ClientChannelHandler$;
import com.linkedin.norbert.network.netty.ClientStatisticsRequestStrategy;
import com.linkedin.norbert.network.netty.ClientStatisticsRequestStrategyMBeanImpl;
import com.linkedin.norbert.network.util.ProtoUtils$;
import com.linkedin.norbert.norbertutils.SystemClock$;
import com.linkedin.norbert.protos.NorbertProtos;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectInstance;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelPipelineCoverage(value="all")
@ScalaSignature(bytes="\u0006\u0001\t%b\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0007\u0003)\rc\u0017.\u001a8u\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0003oKR$\u0018P\u0003\u0002\u0006\r\u00059a.\u001a;x_J\\'BA\u0004\t\u0003\u001dqwN\u001d2feRT!!\u0003\u0006\u0002\u00111Lgn[3eS:T\u0011aC\u0001\u0004G>l7\u0001A\n\u0005\u00019Ir\u0004\u0005\u0002\u0010/5\t\u0001C\u0003\u0002\u0012%\u000591\r[1o]\u0016d'BA\u0002\u0014\u0015\t!R#A\u0003kE>\u001c8OC\u0001\u0017\u0003\ry'oZ\u0005\u00031A\u0011AcU5na2,7\t[1o]\u0016d\u0007*\u00198eY\u0016\u0014\bC\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u0007\u0003\u001dawnZ4j]\u001eL!AH\u000e\u0003\u000f1{wmZ5oOB\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\tY1kY1mC>\u0013'.Z2u\u0011!1\u0003A!A!\u0002\u00139\u0013AC2mS\u0016tGOT1nKB\u0019\u0001\u0005\u000b\u0016\n\u0005%\n#AB(qi&|g\u000e\u0005\u0002,]9\u0011\u0001\u0005L\u0005\u0003[\u0005\na\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q&\t\u0005\te\u0001\u0011\t\u0011)A\u0005U\u0005Y1/\u001a:wS\u000e,g*Y7f\u0011!!\u0004A!A!\u0002\u0013)\u0014aF:uC2,'+Z9vKN$H+[7f_V$X*\u001b8t!\t\u0001c'\u0003\u00028C\t\u0019\u0011J\u001c;\t\u0011e\u0002!\u0011!Q\u0001\nU\n\u0001e\u001d;bY\u0016\u0014V-];fgR\u001cE.Z1okB4%/Z9vK:\u001c\u00170T5og\"A1\b\u0001B\u0001B\u0003%A(A\fsKF,Xm\u001d;Ti\u0006$\u0018n\u001d;jGN<\u0016N\u001c3poB\u0011\u0001%P\u0005\u0003}\u0005\u0012A\u0001T8oO\"A\u0001\t\u0001B\u0001B\u0003%\u0011)A\tpkRd\u0017.\u001a:Nk2$\u0018\u000e\u001d7jKJ\u0004\"\u0001\t\"\n\u0005\r\u000b#A\u0002#pk\ndW\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003B\u0003=yW\u000f\u001e7jKJ\u001cuN\\:uC:$\b\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\u0002\u001fI,7\u000f]8og\u0016D\u0015M\u001c3mKJ\u0004\"!\u0013'\u000e\u0003)S!a\u0013\u0003\u0002\r\rd\u0017.\u001a8u\u0013\ti%JA\bSKN\u0004xN\\:f\u0011\u0006tG\r\\3s\u0011!y\u0005A!A!\u0002\u0013\u0001\u0016aE1w_&$')\u001f;f'R\u0014\u0018N\\4D_BL\bC\u0001\u0011R\u0013\t\u0011\u0016EA\u0004C_>dW-\u00198\t\u000bQ\u0003A\u0011A+\u0002\rqJg.\u001b;?))1\u0006,\u0017.\\9vsv\f\u0019\t\u0003/\u0002i\u0011A\u0001\u0005\u0006MM\u0003\ra\n\u0005\u0006eM\u0003\rA\u000b\u0005\u0006iM\u0003\r!\u000e\u0005\u0006sM\u0003\r!\u000e\u0005\u0006wM\u0003\r\u0001\u0010\u0005\u0006\u0001N\u0003\r!\u0011\u0005\u0006\u000bN\u0003\r!\u0011\u0005\u0006\u000fN\u0003\r\u0001\u0013\u0005\u0006\u001fN\u0003\r\u0001\u0015\u0005\bE\u0002\u0011\r\u0011\"\u0003d\u0003)\u0011X-];fgRl\u0015\r]\u000b\u0002IB!Q\r\u001c8s\u001b\u00051'BA4i\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003S*\fA!\u001e;jY*\t1.\u0001\u0003kCZ\f\u0017BA7g\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003_Bl\u0011\u0001[\u0005\u0003c\"\u0014A!V+J\tB\"1/_A\u0006!\u0015!Xo^A\u0005\u001b\u0005!\u0011B\u0001<\u0005\u0005\u001d\u0011V-];fgR\u0004\"\u0001_=\r\u0001\u0011A!p\u001fC\u0001\u0002\u000b\u0005QPA\u0002`IEBa\u0001 \u0001!\u0002\u0013!\u0017a\u0003:fcV,7\u000f^'ba\u0002\n2A`A\u0002!\t\u0001s0C\u0002\u0002\u0002\u0005\u0012qAT8uQ&tw\rE\u0002!\u0003\u000bI1!a\u0002\"\u0005\r\te.\u001f\t\u0004q\u0006-A!CA\u0007w\u0012\u0005\tQ!\u0001~\u0005\ryFE\r\u0005\n\u0003#\u0001!\u0019!C\u0001\u0003'\t1b\u00197fC:,\b\u000fV1tWV\u0011\u0011Q\u0003\n\u0007\u0003/\ty\"a\u000b\u0007\u0017\u0005e\u00111\u0004C\u0001\u0002\u0003\u0005\u0011Q\u0003\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0016\u0005a1\r\\3b]V\u0004H+Y:lAA!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&)\fA\u0001\\1oO&!\u0011\u0011FA\u0012\u0005\u0019y%M[3diB!\u0011\u0011EA\u0017\u0013\u0011\ty#a\t\u0003\u0011I+hN\\1cY\u0016D!\"a\r\u0002\u0018\t\u0007I\u0011AA\u001b\u0003e\u0019H/\u00197f%\u0016\fX/Z:u)&lWm\\;u\u001b&dG.[:\u0016\u0003qB\u0011\"!\u000f\u0001\u0005\u0004%\t!a\u000f\u0002\u000b\rdwnY6\u0016\u0005\u0005ub\u0002BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\rc!\u0001\u0007o_J\u0014WM\u001d;vi&d7/\u0003\u0003\u0002H\u0005\u0005\u0013aC*zgR,Wn\u00117pG.D\u0001\"a\u0013\u0001A\u0003%\u0011QH\u0001\u0007G2|7m\u001b\u0011\t\u0013\u0005=\u0003A1A\u0005\u0002\u0005E\u0013aD2mK\u0006tW\u000f]#yK\u000e,Ho\u001c:\u0016\u0005\u0005M\u0003cA3\u0002V%\u0019\u0011q\u000b4\u00037M\u001b\u0007.\u001a3vY\u0016$G\u000b\u001b:fC\u0012\u0004vn\u001c7Fq\u0016\u001cW\u000f^8s\u0011!\tY\u0006\u0001Q\u0001\n\u0005M\u0013\u0001E2mK\u0006tW\u000f]#yK\u000e,Ho\u001c:!\u0011%\ty\u0006\u0001b\u0001\n\u0013\t\t'A\u0003ti\u0006$8/\u0006\u0002\u0002dA9\u0011QMA6\u0003_rWBAA4\u0015\r\tI\u0007B\u0001\u0007G>lWn\u001c8\n\t\u00055\u0014q\r\u0002\u0018\u0007\u0006\u001c\u0007.\u001a3OKR<xN]6Ti\u0006$\u0018n\u001d;jGN\u0004B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003k2\u0011aB2mkN$XM]\u0005\u0005\u0003s\n\u0019H\u0001\u0003O_\u0012,\u0007\u0002CA?\u0001\u0001\u0006I!a\u0019\u0002\rM$\u0018\r^:!\u0011%\t\t\t\u0001b\u0001\n\u0003\t\u0019)A\ndY&,g\u000e^*uCR\u001c8\u000b\u001e:bi\u0016<\u00170\u0006\u0002\u0002\u0006B\u0019q+a\"\n\u0007\u0005%%AA\u0010DY&,g\u000e^*uCRL7\u000f^5dgJ+\u0017/^3tiN#(/\u0019;fOfD\u0001\"!$\u0001A\u0003%\u0011QQ\u0001\u0015G2LWM\u001c;Ti\u0006$8o\u0015;sCR,w-\u001f\u0011\t\u0013\u0005E\u0005A1A\u0005\u0002\u0005M\u0015aE:feZ,'/\u0012:s_J\u001cFO]1uK\u001eLXCAAK!\u0011\t)'a&\n\t\u0005e\u0015q\r\u0002\u0016'&l\u0007\u000f\\3CC\u000e\\wN\u001a4TiJ\fG/Z4z\u0011!\ti\n\u0001Q\u0001\n\u0005U\u0015\u0001F:feZ,'/\u0012:s_J\u001cFO]1uK\u001eL\b\u0005C\u0005\u0002\"\u0002\u0011\r\u0011\"\u0001\u0002$\u000612\r\\5f]R\u001cF/\u0019;t'R\u0014\u0018\r^3hs*k\u0005,\u0006\u0002\u0002&B!\u0001\u0005KAT!\u0011\tI+a-\u000e\u0005\u0005-&\u0002BAW\u0003_\u000b!\"\\1oC\u001e,W.\u001a8u\u0015\t\t\t,A\u0003kCZ\f\u00070\u0003\u0003\u00026\u0006-&AD(cU\u0016\u001cG/\u00138ti\u0006t7-\u001a\u0005\t\u0003s\u0003\u0001\u0015!\u0003\u0002&\u000692\r\\5f]R\u001cF/\u0019;t'R\u0014\u0018\r^3hs*k\u0005\f\t\u0005\n\u0003{\u0003!\u0019!C\u0001\u0003G\u000bac]3sm\u0016\u0014XI\u001d:peN#(/\u0019;fOfTU\n\u0017\u0005\t\u0003\u0003\u0004\u0001\u0015!\u0003\u0002&\u000692/\u001a:wKJ,%O]8s'R\u0014\u0018\r^3hs*k\u0005\f\t\u0005\n\u0003\u000b\u0004!\u0019!C\u0001\u0003\u000f\f\u0001b\u001d;sCR,w-_\u000b\u0003\u0003\u0013\u0004B!!\u001a\u0002L&!\u0011QZA4\u0005\u0001\u001au.\u001c9pg&$XmQ1o'\u0016\u0014h/\u001a*fcV,7\u000f^*ue\u0006$XmZ=\t\u0011\u0005E\u0007\u0001)A\u0005\u0003\u0013\f\u0011b\u001d;sCR,w-\u001f\u0011\t\u0013\u0005U\u0007A1A\u0005\n\u0005\r\u0016\u0001C:uCR\u001c(*\u0014-\t\u0011\u0005e\u0007\u0001)A\u0005\u0003K\u000b\u0011b\u001d;biNTU\n\u0017\u0011\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\u0006qqO]5uKJ+\u0017/^3ti\u0016$GCBAq\u0003O\f\t\u0010E\u0002!\u0003GL1!!:\"\u0005\u0011)f.\u001b;\t\u0011\u0005%\u00181\u001ca\u0001\u0003W\f1a\u0019;y!\ry\u0011Q^\u0005\u0004\u0003_\u0004\"!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0003g\fY\u000e1\u0001\u0002v\u0006\tQ\rE\u0002\u0010\u0003oL1!!?\u0011\u00051iUm]:bO\u0016,e/\u001a8u\u0011\u001d\ti\u0010\u0001C!\u0003\u007f\fq\"\\3tg\u0006<WMU3dK&4X\r\u001a\u000b\u0007\u0003C\u0014\tAa\u0001\t\u0011\u0005%\u00181 a\u0001\u0003WD\u0001\"a=\u0002|\u0002\u0007\u0011Q\u001f\u0005\b\u0005\u000f\u0001A\u0011\tB\u0005\u0003=)\u0007pY3qi&|gnQ1vO\"$HCBAq\u0005\u0017\u0011i\u0001\u0003\u0005\u0002j\n\u0015\u0001\u0019AAv\u0011!\t\u0019P!\u0002A\u0002\t=\u0001cA\b\u0003\u0012%\u0019!1\u0003\t\u0003\u001d\u0015C8-\u001a9uS>tWI^3oi\"9!q\u0003\u0001\u0005\u0002\te\u0011\u0001C:ikR$wn\u001e8\u0016\u0005\u0005\u0005\bf\u0002\u0001\u0003\u001e\t\r\"Q\u0005\t\u0004\u001f\t}\u0011b\u0001B\u0011!\t92\t[1o]\u0016d\u0007+\u001b9fY&tWmQ8wKJ\fw-Z\u0001\u0006m\u0006dW/Z\u0011\u0003\u0005O\t1!\u00197m\u0001")
public class ClientChannelHandler
extends SimpleChannelHandler
implements Logging,
ScalaObject {
    public final int com$linkedin$norbert$network$netty$ClientChannelHandler$$staleRequestTimeoutMins;
    private final ResponseHandler responseHandler;
    private final boolean avoidByteStringCopy;
    private final ConcurrentHashMap com$linkedin$norbert$network$netty$ClientChannelHandler$$requestMap;
    private final Runnable cleanupTask;
    private final SystemClock$ clock;
    private final ScheduledThreadPoolExecutor cleanupExecutor;
    private final CachedNetworkStatistics com$linkedin$norbert$network$netty$ClientChannelHandler$$stats;
    private final ClientStatisticsRequestStrategy clientStatsStrategy;
    private final SimpleBackoffStrategy serverErrorStrategy;
    private final Option<ObjectInstance> clientStatsStrategyJMX;
    private final Option<ObjectInstance> serverErrorStrategyJMX;
    private final CompositeCanServeRequestStrategy strategy;
    private final Option<ObjectInstance> statsJMX;
    private final Logger log;

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void com$linkedin$norbert$logging$Logging$_setter_$log_$eq(Logger logger) {
        this.log = logger;
    }

    public final ConcurrentHashMap com$linkedin$norbert$network$netty$ClientChannelHandler$$requestMap() {
        return this.com$linkedin$norbert$network$netty$ClientChannelHandler$$requestMap;
    }

    public Runnable cleanupTask() {
        return this.cleanupTask;
    }

    public SystemClock$ clock() {
        return this.clock;
    }

    public ScheduledThreadPoolExecutor cleanupExecutor() {
        return this.cleanupExecutor;
    }

    public final CachedNetworkStatistics com$linkedin$norbert$network$netty$ClientChannelHandler$$stats() {
        return this.com$linkedin$norbert$network$netty$ClientChannelHandler$$stats;
    }

    public ClientStatisticsRequestStrategy clientStatsStrategy() {
        return this.clientStatsStrategy;
    }

    public SimpleBackoffStrategy serverErrorStrategy() {
        return this.serverErrorStrategy;
    }

    public Option<ObjectInstance> clientStatsStrategyJMX() {
        return this.clientStatsStrategyJMX;
    }

    public Option<ObjectInstance> serverErrorStrategyJMX() {
        return this.serverErrorStrategyJMX;
    }

    public CompositeCanServeRequestStrategy strategy() {
        return this.strategy;
    }

    private Option<ObjectInstance> statsJMX() {
        return this.statsJMX;
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) {
        Request request$1 = (Request)e.getMessage();
        this.log().debug((Function0<String>)new $anonfun$writeRequested$1(this, request$1));
        if (!request$1.callback().isEmpty()) {
            this.com$linkedin$norbert$network$netty$ClientChannelHandler$$requestMap().put(request$1.id(), request$1);
            this.com$linkedin$norbert$network$netty$ClientChannelHandler$$stats().beginRequest(request$1.node(), request$1.id());
        }
        NorbertProtos.NorbertMessage.Builder message$1 = NorbertProtos.NorbertMessage.newBuilder();
        message$1.setRequestIdMsb(request$1.id().getMostSignificantBits());
        message$1.setRequestIdLsb(request$1.id().getLeastSignificantBits());
        message$1.setMessageName(request$1.name());
        request$1.headers().foreach((Function1)new $anonfun$writeRequested$2(this, message$1));
        message$1.setMessage(ProtoUtils$.MODULE$.byteArrayToByteString(request$1.requestBytes(), this.avoidByteStringCopy));
        super.writeRequested(ctx, (MessageEvent)new DownstreamMessageEvent(e.getChannel(), e.getFuture(), (Object)message$1.build(), e.getRemoteAddress()));
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        NorbertProtos.NorbertMessage message$2 = (NorbertProtos.NorbertMessage)e.getMessage();
        this.log().debug((Function0<String>)new $anonfun$messageReceived$1(this, message$2));
        UUID requestId = new UUID(message$2.getRequestIdMsb(), message$2.getRequestIdLsb());
        Request request = (Request)this.com$linkedin$norbert$network$netty$ClientChannelHandler$$requestMap().get(requestId);
        if (request == null) {
            this.log().warn((Function0<String>)new $anonfun$messageReceived$2(this, message$2));
        } else {
            Request request2 = request;
            this.com$linkedin$norbert$network$netty$ClientChannelHandler$$requestMap().remove(requestId);
            this.com$linkedin$norbert$network$netty$ClientChannelHandler$$stats().endRequest(request2.node(), request2.id());
            NorbertProtos.NorbertMessage.Status status = message$2.getStatus();
            NorbertProtos.NorbertMessage.Status status2 = NorbertProtos.NorbertMessage.Status.OK;
            if (!(status != null ? !((Object)((Object)status)).equals((Object)status2) : status2 != null)) {
                this.responseHandler.onSuccess(request2, message$2);
            } else {
                NorbertProtos.NorbertMessage.Status status3 = message$2.getStatus();
                NorbertProtos.NorbertMessage.Status status4 = NorbertProtos.NorbertMessage.Status.HEAVYLOAD;
                if (!(status3 != null ? !((Object)((Object)status3)).equals((Object)status4) : status4 != null)) {
                    this.serverErrorStrategy().notifyFailure(request2.node());
                    this.processException$1(request2, "Heavy load");
                } else {
                    this.processException$1(request2, (String)Option$.MODULE$.apply((Object)message$2.getErrorMessage()).getOrElse((Function0)new $anonfun$messageReceived$3(this)));
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        this.log().warn(e.getCause(), (Function0<String>)new $anonfun$exceptionCaught$1(this));
    }

    public void shutdown() {
        this.responseHandler.shutdown();
        this.cleanupExecutor().shutdownNow();
        this.statsJMX().foreach((Function1)new $anonfun$shutdown$1(this));
        this.serverErrorStrategyJMX().foreach((Function1)new $anonfun$shutdown$2(this));
        this.clientStatsStrategyJMX().foreach((Function1)new $anonfun$shutdown$3(this));
    }

    private final void processException$1(Request requestCtx$1, String errorMessage$1) {
        this.responseHandler.onFailure(requestCtx$1, new $anon$1(this, requestCtx$1, errorMessage$1));
    }

    public ClientChannelHandler(Option<String> clientName, String serviceName, int staleRequestTimeoutMins, int staleRequestCleanupFrequencyMins, long requestStatisticsWindow, double outlierMultiplier, double outlierConstant, ResponseHandler responseHandler2, boolean avoidByteStringCopy) {
        this.com$linkedin$norbert$network$netty$ClientChannelHandler$$staleRequestTimeoutMins = staleRequestTimeoutMins;
        this.responseHandler = responseHandler2;
        this.avoidByteStringCopy = avoidByteStringCopy;
        Logging$class.$init$(this);
        this.com$linkedin$norbert$network$netty$ClientChannelHandler$$requestMap = new ConcurrentHashMap();
        this.cleanupTask = new $anon$2(this);
        this.clock = SystemClock$.MODULE$;
        this.cleanupExecutor = new ScheduledThreadPoolExecutor(1);
        this.cleanupExecutor().scheduleAtFixedRate(this.cleanupTask(), staleRequestCleanupFrequencyMins, staleRequestCleanupFrequencyMins, TimeUnit.MINUTES);
        this.com$linkedin$norbert$network$netty$ClientChannelHandler$$stats = CachedNetworkStatistics$.MODULE$.apply(this.clock(), requestStatisticsWindow, 200L);
        this.clientStatsStrategy = new ClientStatisticsRequestStrategy(this.com$linkedin$norbert$network$netty$ClientChannelHandler$$stats(), outlierMultiplier, outlierConstant, this.clock());
        this.serverErrorStrategy = new SimpleBackoffStrategy(this.clock(), SimpleBackoffStrategy$.MODULE$.init$default$2(), SimpleBackoffStrategy$.MODULE$.init$default$3());
        this.clientStatsStrategyJMX = JMX$.MODULE$.register(new ClientStatisticsRequestStrategyMBeanImpl(clientName, serviceName, this.clientStatsStrategy()));
        this.serverErrorStrategyJMX = JMX$.MODULE$.register(new ServerErrorStrategyMBeanImpl(clientName, serviceName, this.serverErrorStrategy()));
        this.strategy = new CompositeCanServeRequestStrategy((Seq<CanServeRequestStrategy>)Predef$.MODULE$.wrapRefArray((Object[])new CanServeRequestStrategy[]{this.clientStatsStrategy(), this.serverErrorStrategy()}));
        this.statsJMX = JMX$.MODULE$.register(new NetworkClientStatisticsMBeanImpl(clientName, serviceName, this.com$linkedin$norbert$network$netty$ClientChannelHandler$$stats()));
    }
}

