/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.network.netty;

import com.linkedin.norbert.jmx.JMX$;
import com.linkedin.norbert.logging.Logger;
import com.linkedin.norbert.logging.Logging;
import com.linkedin.norbert.logging.Logging$class;
import com.linkedin.norbert.network.HeavyLoadException;
import com.linkedin.norbert.network.InputSerializer;
import com.linkedin.norbert.network.InvalidMessageException;
import com.linkedin.norbert.network.OutputSerializer;
import com.linkedin.norbert.network.common.CachedNetworkStatistics;
import com.linkedin.norbert.network.common.CachedNetworkStatistics$;
import com.linkedin.norbert.network.netty.NetworkServerStatisticsMBeanImpl;
import com.linkedin.norbert.network.netty.RequestContext;
import com.linkedin.norbert.network.netty.ResponseHelper$;
import com.linkedin.norbert.network.netty.ServerChannelHandler$;
import com.linkedin.norbert.network.server.MessageExecutor;
import com.linkedin.norbert.network.server.MessageHandlerRegistry;
import com.linkedin.norbert.network.util.ProtoUtils$;
import com.linkedin.norbert.norbertutils.SystemClock$;
import com.linkedin.norbert.protos.NorbertProtos;
import java.util.UUID;
import javax.management.ObjectInstance;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import scala.Either;
import scala.Function0;
import scala.Function1;
import scala.Left;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Right;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ChannelPipelineCoverage(value="all")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0007\u0003)M+'O^3s\u0007\"\fgN\\3m\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0003oKR$\u0018P\u0003\u0002\u0006\r\u00059a.\u001a;x_J\\'BA\u0004\t\u0003\u001dqwN\u001d2feRT!!\u0003\u0006\u0002\u00111Lgn[3eS:T\u0011aC\u0001\u0004G>l7\u0001A\n\u0005\u00019Ir\u0004\u0005\u0002\u0010/5\t\u0001C\u0003\u0002\u0012%\u000591\r[1o]\u0016d'BA\u0002\u0014\u0015\t!R#A\u0003kE>\u001c8OC\u0001\u0017\u0003\ry'oZ\u0005\u00031A\u0011AcU5na2,7\t[1o]\u0016d\u0007*\u00198eY\u0016\u0014\bC\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\u0007\u0003\u001dawnZ4j]\u001eL!AH\u000e\u0003\u000f1{wmZ5oOB\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\tY1kY1mC>\u0013'.Z2u\u0011!1\u0003A!A!\u0002\u00139\u0013AC2mS\u0016tGOT1nKB\u0019\u0001\u0005\u000b\u0016\n\u0005%\n#AB(qi&|g\u000e\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!A.\u00198h\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\rM#(/\u001b8h\u0011!\u0019\u0004A!A!\u0002\u0013Q\u0013aC:feZL7-\u001a(b[\u0016D\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\rG\"\fgN\\3m\u000fJ|W\u000f\u001d\t\u0003oij\u0011\u0001\u000f\u0006\u0003sA\tQa\u001a:pkBL!a\u000f\u001d\u0003\u0019\rC\u0017M\u001c8fY\u001e\u0013x.\u001e9\t\u0011u\u0002!\u0011!Q\u0001\ny\na#\\3tg\u0006<W\rS1oI2,'OU3hSN$(/\u001f\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u0012\taa]3sm\u0016\u0014\u0018BA\"A\u0005YiUm]:bO\u0016D\u0015M\u001c3mKJ\u0014VmZ5tiJL\b\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u001f5,7o]1hK\u0016CXmY;u_J\u0004\"aP$\n\u0005!\u0003%aD'fgN\fw-Z#yK\u000e,Ho\u001c:\t\u0011)\u0003!\u0011!Q\u0001\n-\u000bqC]3rk\u0016\u001cHo\u0015;bi&\u001cH/[2t/&tGm\\<\u0011\u0005\u0001b\u0015BA'\"\u0005\u0011auN\\4\t\u0011=\u0003!\u0011!Q\u0001\nA\u000b1#\u0019<pS\u0012\u0014\u0015\u0010^3TiJLgnZ\"paf\u0004\"\u0001I)\n\u0005I\u000b#a\u0002\"p_2,\u0017M\u001c\u0005\u0006)\u0002!\t!V\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011YC\u0016LW.];z\u0003\"a\u0016\u0001\u000e\u0003\tAQAJ*A\u0002\u001dBQaM*A\u0002)BQ!N*A\u0002YBQ!P*A\u0002yBQ!R*A\u0002\u0019CQAS*A\u0002-CQaT*A\u0002ACq\u0001\u0019\u0001C\u0002\u0013%\u0011-\u0001\u0006ti\u0006$8/Q2u_J,\u0012A\u0019\t\u0005G\u001aD7.D\u0001e\u0015\t)G!\u0001\u0004d_6lwN\\\u0005\u0003O\u0012\u0014qcQ1dQ\u0016$g*\u001a;x_J\\7\u000b^1uSN$\u0018nY:\u0011\u0005\u0001J\u0017B\u00016\"\u0005\rIe\u000e\u001e\t\u0003Y>l\u0011!\u001c\u0006\u0003]:\nA!\u001e;jY&\u0011\u0001/\u001c\u0002\u0005+VKE\t\u0003\u0004s\u0001\u0001\u0006IAY\u0001\fgR\fGo]!di>\u0014\b\u0005C\u0004u\u0001\t\u0007I\u0011A;\u0002\u0011M$\u0018\r^:K[b,\u0012A\u001e\t\u0004A!:\bC\u0001=~\u001b\u0005I(B\u0001>|\u0003)i\u0017M\\1hK6,g\u000e\u001e\u0006\u0002y\u0006)!.\u0019<bq&\u0011a0\u001f\u0002\u000f\u001f\nTWm\u0019;J]N$\u0018M\\2f\u0011\u001d\t\t\u0001\u0001Q\u0001\nY\f\u0011b\u001d;biNTU\u000e\u001f\u0011\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b\u0005A1\u000f[;uI><h.\u0006\u0002\u0002\nA\u0019\u0001%a\u0003\n\u0007\u00055\u0011E\u0001\u0003V]&$\bbBA\t\u0001\u0011\u0005\u00131C\u0001\fG\"\fgN\\3m\u001fB,g\u000e\u0006\u0004\u0002\n\u0005U\u0011q\u0004\u0005\t\u0003/\ty\u00011\u0001\u0002\u001a\u0005\u00191\r\u001e=\u0011\u0007=\tY\"C\u0002\u0002\u001eA\u0011Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000f\u0003\u0005\u0002\"\u0005=\u0001\u0019AA\u0012\u0003\u0005)\u0007cA\b\u0002&%\u0019\u0011q\u0005\t\u0003#\rC\u0017M\u001c8fYN#\u0018\r^3Fm\u0016tG\u000fC\u0004\u0002,\u0001!\t%!\f\u0002\u001f5,7o]1hKJ+7-Z5wK\u0012$b!!\u0003\u00020\u0005E\u0002\u0002CA\f\u0003S\u0001\r!!\u0007\t\u0011\u0005\u0005\u0012\u0011\u0006a\u0001\u0003g\u00012aDA\u001b\u0013\r\t9\u0004\u0005\u0002\r\u001b\u0016\u001c8/Y4f\u000bZ,g\u000e\u001e\u0005\b\u0003w\u0001A\u0011IA\u001f\u0003=)\u0007pY3qi&|gnQ1vO\"$HCBA\u0005\u0003\u007f\t\t\u0005\u0003\u0005\u0002\u0018\u0005e\u0002\u0019AA\r\u0011!\t\t#!\u000fA\u0002\u0005\r\u0003cA\b\u0002F%\u0019\u0011q\t\t\u0003\u001d\u0015C8-\u001a9uS>tWI^3oi\"9\u00111\n\u0001\u0005\u0002\u00055\u0013a\u0004:fgB|gn]3IC:$G.\u001a:\u0016\r\u0005=\u00131MA<)!\t\t&!\"\u0002\u0010\u0006]eCBA\u0005\u0003'\nY\b\u0003\u0005\u0002V\u0005%\u00039AA,\u0003\tI7\u000f\u0005\u0005\u0002Z\u0005m\u0013qLA;\u001b\u0005!\u0011bAA/\t\ty\u0011J\u001c9viN+'/[1mSj,'\u000f\u0005\u0003\u0002b\u0005\rD\u0002\u0001\u0003\f\u0003K\nI\u0005\"A\u0001\u0006\u0004\t9G\u0001\u0006SKF,Xm\u001d;Ng\u001e\fB!!\u001b\u0002pA\u0019\u0001%a\u001b\n\u0007\u00055\u0014EA\u0004O_RD\u0017N\\4\u0011\u0007\u0001\n\t(C\u0002\u0002t\u0005\u00121!\u00118z!\u0011\t\t'a\u001e\u0005\u0017\u0005e\u0014\u0011\nC\u0001\u0002\u000b\u0007\u0011q\r\u0002\f%\u0016\u001c\bo\u001c8tK6\u001bx\r\u0003\u0005\u0002~\u0005%\u00039AA@\u0003\ty7\u000f\u0005\u0005\u0002Z\u0005\u0005\u0015qLA;\u0013\r\t\u0019\t\u0002\u0002\u0011\u001fV$\b/\u001e;TKJL\u0017\r\\5{KJD\u0001\"a\"\u0002J\u0001\u0007\u0011\u0011R\u0001\bG>tG/\u001a=u!\r9\u00161R\u0005\u0004\u0003\u001b\u0013!A\u0004*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0005\b#\u0005%\u0003\u0019AAI!\ry\u00111S\u0005\u0004\u0003+\u0003\"aB\"iC:tW\r\u001c\u0005\t\u00033\u000bI\u00051\u0001\u0002\u001c\u00061Q-\u001b;iKJ\u0004r\u0001IAO\u0003C\u000b)(C\u0002\u0002 \u0006\u0012a!R5uQ\u0016\u0014\b\u0003BAR\u0003gsA!!*\u00020:!\u0011qUAW\u001b\t\tIKC\u0002\u0002,2\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0012\n\u0007\u0005E\u0016%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005U\u0016q\u0017\u0002\n\u000bb\u001cW\r\u001d;j_:T1!!-\"Q\u001d\u0001\u00111XAa\u0003\u0007\u00042aDA_\u0013\r\ty\f\u0005\u0002\u0018\u0007\"\fgN\\3m!&\u0004X\r\\5oK\u000e{g/\u001a:bO\u0016\fQA^1mk\u0016\f#!!2\u0002\u0007\u0005dG\u000e")
public class ServerChannelHandler
extends SimpleChannelHandler
implements Logging,
ScalaObject {
    private final ChannelGroup channelGroup;
    private final MessageHandlerRegistry messageHandlerRegistry;
    private final MessageExecutor messageExecutor;
    private final boolean avoidByteStringCopy;
    private final CachedNetworkStatistics<Integer, UUID> statsActor;
    private final Option<ObjectInstance> statsJmx;
    private final Logger log;

    @Override
    public Logger log() {
        return this.log;
    }

    @Override
    public void com$linkedin$norbert$logging$Logging$_setter_$log_$eq(Logger logger) {
        this.log = logger;
    }

    private CachedNetworkStatistics<Integer, UUID> statsActor() {
        return this.statsActor;
    }

    public Option<ObjectInstance> statsJmx() {
        return this.statsJmx;
    }

    public void shutdown() {
        this.statsJmx().foreach((Function1)new $anonfun$shutdown$1(this));
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Channel channel$1 = e.getChannel();
        this.log().trace((Function0<String>)new $anonfun$channelOpen$1(this, channel$1));
        this.channelGroup.add(channel$1);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e$1) {
        Tuple3 tuple3;
        byte[] requestBytes;
        Channel channel;
        RequestContext context$3;
        block5: {
            Tuple2 tuple2 = (Tuple2)e$1.getMessage();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            context$3 = (RequestContext)tuple22._1();
            NorbertProtos.NorbertMessage norbertMessage = (NorbertProtos.NorbertMessage)tuple22._2();
            channel = e$1.getChannel();
            String messageName = norbertMessage.getMessageName();
            requestBytes = ProtoUtils$.MODULE$.byteStringToByteArray(norbertMessage.getMessage(), this.avoidByteStringCopy);
            this.statsActor().beginRequest(BoxesRunTime.boxToInteger((int)0), context$3.requestId());
            Tuple3 exceptionResult1 = null;
            try {
                Function1 handler = this.messageHandlerRegistry.handlerFor(messageName);
                InputSerializer is = this.messageHandlerRegistry.inputSerializerFor(messageName);
                OutputSerializer os = this.messageHandlerRegistry.outputSerializerFor(messageName);
                tuple3 = exceptionResult1 = new Tuple3(handler, is, os);
                if (tuple3 != null) break block5;
            }
            catch (InvalidMessageException invalidMessageException) {
                Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future((Channel)channel), (Object)new Tuple2((Object)context$3, (Object)ResponseHelper$.MODULE$.errorResponse(context$3.requestId(), invalidMessageException, ResponseHelper$.MODULE$.errorResponse$default$3())));
                this.statsActor().endRequest(BoxesRunTime.boxToInteger((int)0), context$3.requestId());
                throw invalidMessageException;
            }
            throw new MatchError((Object)tuple3);
        }
        Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
        Function1 handler = (Function1)tuple32._1();
        InputSerializer is$1 = (InputSerializer)tuple32._2();
        OutputSerializer os$1 = (OutputSerializer)tuple32._3();
        Object request = is$1.requestFromBytes(requestBytes);
        try {
            this.messageExecutor.executeMessage(request, Option$.MODULE$.apply((Object)new $anonfun$messageReceived$1(this, e$1, context$3, is$1, os$1)), (Option<com.linkedin.norbert.network.server.RequestContext>)new Some((Object)context$3), is$1);
        }
        catch (HeavyLoadException heavyLoadException) {
            Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)Channels.future((Channel)channel), (Object)new Tuple2((Object)context$3, (Object)ResponseHelper$.MODULE$.errorResponse(context$3.requestId(), heavyLoadException, NorbertProtos.NorbertMessage.Status.HEAVYLOAD)));
            this.statsActor().endRequest(BoxesRunTime.boxToInteger((int)0), context$3.requestId());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e$2) {
        this.log().info(e$2.getCause(), (Function0<String>)new $anonfun$exceptionCaught$1(this, e$2));
    }

    public <RequestMsg, ResponseMsg> void responseHandler(RequestContext context, Channel channel, Either<Exception, ResponseMsg> either, InputSerializer<RequestMsg, ResponseMsg> is, OutputSerializer<RequestMsg, ResponseMsg> os) {
        Either<Exception, ResponseMsg> either2;
        block4: {
            NorbertProtos.NorbertMessage norbertMessage;
            block3: {
                block2: {
                    either2 = either;
                    if (!(either2 instanceof Left)) break block2;
                    norbertMessage = ResponseHelper$.MODULE$.errorResponse(context.requestId(), (Exception)((Left)either2).a(), ResponseHelper$.MODULE$.errorResponse$default$3());
                    break block3;
                }
                if (!(either2 instanceof Right)) break block4;
                norbertMessage = ResponseHelper$.MODULE$.responseBuilder(context.requestId()).setMessageName(os.responseName()).setMessage(ProtoUtils$.MODULE$.byteArrayToByteString(os.responseToBytes(((Right)either2).b()), this.avoidByteStringCopy)).build();
            }
            NorbertProtos.NorbertMessage response$1 = norbertMessage;
            this.log().debug((Function0<String>)new $anonfun$responseHandler$1(this, response$1));
            channel.write((Object)new Tuple2((Object)context, (Object)response$1));
            this.statsActor().endRequest(BoxesRunTime.boxToInteger((int)0), context.requestId());
            return;
        }
        throw new MatchError(either2);
    }

    public ServerChannelHandler(Option<String> clientName, String serviceName, ChannelGroup channelGroup, MessageHandlerRegistry messageHandlerRegistry, MessageExecutor messageExecutor, long requestStatisticsWindow, boolean avoidByteStringCopy) {
        this.channelGroup = channelGroup;
        this.messageHandlerRegistry = messageHandlerRegistry;
        this.messageExecutor = messageExecutor;
        this.avoidByteStringCopy = avoidByteStringCopy;
        Logging$class.$init$(this);
        this.statsActor = CachedNetworkStatistics$.MODULE$.apply(SystemClock$.MODULE$, requestStatisticsWindow, 200L);
        this.statsJmx = JMX$.MODULE$.register(new NetworkServerStatisticsMBeanImpl(clientName, serviceName, this.statsActor()));
    }
}

