/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.network.partitioned.loadbalancer;

import com.linkedin.norbert.cluster.InvalidClusterException;
import com.linkedin.norbert.network.common.Endpoint;
import com.linkedin.norbert.network.partitioned.loadbalancer.DefaultLoadBalancerHelper;
import com.linkedin.norbert.network.partitioned.loadbalancer.DefaultLoadBalancerHelper$;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class DefaultLoadBalancerHelper$class {
    public static /* synthetic */ Option nodeForPartition$default$3(DefaultLoadBalancerHelper $this) {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option nodeForPartition$default$2(DefaultLoadBalancerHelper $this) {
        return None$.MODULE$;
    }

    public static Map generatePartitionToNodeMap(DefaultLoadBalancerHelper $this, scala.collection.immutable.Set nodes2, int numPartitions, boolean serveRequestsIfPartitionMissing) {
        scala.collection.immutable.Set missingPartitions$1;
        block5: {
            Map partitionToNodeMap;
            block4: {
                partitionToNodeMap = (Map)((TraversableOnce)nodes2.flatMap((Function1)new DefaultLoadBalancerHelper$.anonfun.1($this), Set$.MODULE$.canBuildFrom())).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2)new DefaultLoadBalancerHelper$.anonfun.2($this));
                scala.collection.immutable.Set possiblePartitions = ((TraversableOnce)Predef$.MODULE$.intWrapper(0).until(numPartitions)).toSet();
                missingPartitions$1 = (scala.collection.immutable.Set)possiblePartitions.diff((Set)partitionToNodeMap.keys().toSet());
                if (missingPartitions$1.size() == possiblePartitions.size()) {
                    throw new InvalidClusterException(Predef$.MODULE$.augmentString("Every single partition appears to be missing. There are %d partitions").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numPartitions)})));
                }
                if (missingPartitions$1.isEmpty()) break block4;
                if (!serveRequestsIfPartitionMissing) break block5;
                $this.log().warn((Function0<String>)new DefaultLoadBalancerHelper$.anonfun.generatePartitionToNodeMap.1($this, missingPartitions$1));
            }
            return (Map)partitionToNodeMap.map((Function1)new DefaultLoadBalancerHelper$.anonfun.generatePartitionToNodeMap.2($this), Map$.MODULE$.canBuildFrom());
        }
        throw new InvalidClusterException(Predef$.MODULE$.augmentString("Partitions %s are unavailable, cannot serve requests.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingPartitions$1})));
    }

    public static Option nodeForPartition(DefaultLoadBalancerHelper $this, int partitionId, Option capability, Option persistentCapability) {
        Option option = $this.partitionToNodeMap().get((Object)BoxesRunTime.boxToInteger((int)partitionId));
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            int idx;
            Some some = (Some)option;
            Tuple3 tuple3 = (Tuple3)some.x();
            if (tuple3 == null) {
                throw new MatchError((Object)option);
            }
            IndexedSeq indexedSeq = (IndexedSeq)tuple3._1();
            AtomicInteger atomicInteger = (AtomicInteger)tuple3._2();
            AtomicBoolean[] atomicBooleanArray = (AtomicBoolean[])tuple3._3();
            IndexedSeq endpoints = indexedSeq;
            AtomicInteger counter = atomicInteger;
            AtomicBoolean[] states = atomicBooleanArray;
            int es = endpoints.size();
            counter.compareAndSet(Integer.MAX_VALUE, 0);
            int i = idx = counter.getAndIncrement();
            do {
                Object object;
                Endpoint endpoint;
                if ((endpoint = (Endpoint)endpoints.apply(i % es)).canServeRequests() && endpoint.node().isCapableOf((Option<Long>)capability, (Option<Long>)persistentCapability)) {
                    if (states[i % es].compareAndSet(true, false)) {
                        return new Some((Object)endpoint.node());
                    }
                    object = i - idx >= es ? BoxesRunTime.boxToBoolean((boolean)states[i % es].compareAndSet(false, true)) : BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
                if (++i >= 0) continue;
                i = 0;
            } while (i != idx);
            return new Some((Object)((Endpoint)endpoints.apply(idx)).node());
        }
        throw new MatchError((Object)option);
    }

    public static void $init$(DefaultLoadBalancerHelper $this) {
    }
}

