/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.norbert.network.partitioned.loadbalancer;

import com.linkedin.norbert.cluster.InvalidClusterException;
import com.linkedin.norbert.network.common.Endpoint;
import com.linkedin.norbert.network.partitioned.loadbalancer.DefaultPartitionedLoadBalancerFactory;
import com.linkedin.norbert.network.partitioned.loadbalancer.PartitionedConsistentHashedLoadBalancer;
import com.linkedin.norbert.network.partitioned.loadbalancer.PartitionedConsistentHashedLoadBalancerFactory$;
import java.util.TreeMap;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001f\tq\u0003+\u0019:uSRLwN\\3e\u0007>t7/[:uK:$\b*Y:iK\u0012du.\u00193CC2\fgnY3s\r\u0006\u001cGo\u001c:z\u0015\t\u0019A!\u0001\u0007m_\u0006$'-\u00197b]\u000e,'O\u0003\u0002\u0006\r\u0005Y\u0001/\u0019:uSRLwN\\3e\u0015\t9\u0001\"A\u0004oKR<xN]6\u000b\u0005%Q\u0011a\u00028pe\n,'\u000f\u001e\u0006\u0003\u00171\t\u0001\u0002\\5oW\u0016$\u0017N\u001c\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001U\u0011\u0001cF\n\u0004\u0001E\u0019\u0003c\u0001\n\u0014+5\t!!\u0003\u0002\u0015\u0005\t)C)\u001a4bk2$\b+\u0019:uSRLwN\\3e\u0019>\fGMQ1mC:\u001cWM\u001d$bGR|'/\u001f\t\u0003-]a\u0001\u0001\u0002\u0005\u0019\u0001\u0011\u0005\tQ1\u0001\u001a\u00055\u0001\u0016M\u001d;ji&|g.\u001a3JIF\u0011!\u0004\t\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\b\u001d>$\b.\u001b8h!\tY\u0012%\u0003\u0002#9\t\u0019\u0011I\\=\u0011\u0005m!\u0013BA\u0013\u001d\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bCA\u000e*\u0013\tQCDA\u0002J]RD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\f]Vl'+\u001a9mS\u000e\f7\u000f\u0003\u0005/\u0001\t\u0005\t\u0015!\u00030\u0003\u0019A\u0017m\u001d5G]B!1\u0004M\u000b)\u0013\t\tDDA\u0005Gk:\u001cG/[8oc!A1\u0007\u0001B\u0001B\u0003%A'\u0001\bf]\u0012\u0004x.\u001b8u\u0011\u0006\u001c\bN\u00128\u0011\tm\u0001T\u0007\u000b\t\u0003mer!aG\u001c\n\u0005ab\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\u000f\t\u0011u\u0002!\u0011!Q\u0001\ny\nqd]3sm\u0016\u0014V-];fgR\u001c\u0018J\u001a)beRLG/[8o\u001b&\u001c8/\u001b8h!\tYr(\u0003\u0002A9\t9!i\\8mK\u0006t\u0007\"\u0002\"\u0001\t\u0003\u0019\u0015A\u0002\u001fj]&$h\b\u0006\u0004E\u000b\u001a;\u0005*\u0013\t\u0004%\u0001)\u0002\"B\u0014B\u0001\u0004A\u0003\"\u0002\u0017B\u0001\u0004A\u0003\"\u0002\u0018B\u0001\u0004y\u0003\"B\u001aB\u0001\u0004!\u0004\"B\u001fB\u0001\u0004q\u0004\"\u0002\"\u0001\t\u0003YE#\u0002#M\u001d>\u0003\u0006\"B'K\u0001\u0004A\u0013!E:mS\u000e,7\u000fU3s\u000b:$\u0007o\\5oi\")aF\u0013a\u0001_!)1G\u0013a\u0001i!)QH\u0013a\u0001}!)!\u000b\u0001C\u0001'\u0006\u0001r-\u001a;Ok6\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003QQCQ!V)A\u0002Y\u000b\u0011\"\u001a8ea>Lg\u000e^:\u0011\u0007Y:\u0016,\u0003\u0002Yw\t\u00191+\u001a;\u0011\u0005ikV\"A.\u000b\u0005q3\u0011AB2p[6|g.\u0003\u0002_7\nAQI\u001c3q_&tG\u000fC\u0003a\u0001\u0011E\u0011-A\u0007dC2\u001cW\u000f\\1uK\"\u000b7\u000f\u001b\u000b\u0003Q\tDQaY0A\u0002U\t!!\u001b3\t\u000b\u0015\u0004A\u0011\t4\u0002\u001f9,w\u000fT8bI\n\u000bG.\u00198dKJ$\"a\u001a6\u0011\u0007IAW#\u0003\u0002j\u0005\t9\u0003+\u0019:uSRLwN\\3e\u0007>t7/[:uK:$\b*Y:iK\u0012du.\u00193CC2\fgnY3s\u0011\u0015)F\r1\u0001WQ\r!Gn\u001c\t\u000375L!A\u001c\u000f\u0003\rQD'o\\<tG\u0005\u0001\bCA9u\u001b\u0005\u0011(BA:\t\u0003\u001d\u0019G.^:uKJL!!\u001e:\u0003/%sg/\u00197jI\u000ecWo\u001d;fe\u0016C8-\u001a9uS>t\u0007")
public class PartitionedConsistentHashedLoadBalancerFactory<PartitionedId>
extends DefaultPartitionedLoadBalancerFactory<PartitionedId>
implements ScalaObject {
    private final int numPartitions;
    public final int com$linkedin$norbert$network$partitioned$loadbalancer$PartitionedConsistentHashedLoadBalancerFactory$$numReplicas;
    private final Function1<PartitionedId, Integer> hashFn;
    public final Function1 com$linkedin$norbert$network$partitioned$loadbalancer$PartitionedConsistentHashedLoadBalancerFactory$$endpointHashFn;
    private final boolean serveRequestsIfPartitionMissing;

    public PartitionedConsistentHashedLoadBalancerFactory(int slicesPerEndpoint, Function1<PartitionedId, Integer> hashFn, Function1<String, Integer> endpointHashFn, boolean serveRequestsIfPartitionMissing) {
        this(-1, slicesPerEndpoint, hashFn, endpointHashFn, serveRequestsIfPartitionMissing);
    }

    @Override
    public int getNumPartitions(Set<Endpoint> endpoints) {
        return this.numPartitions == -1 ? ((TraversableOnce)endpoints.flatMap((Function1)new $anonfun$getNumPartitions$1(this), Set$.MODULE$.canBuildFrom())).size() : this.numPartitions;
    }

    @Override
    public int calculateHash(PartitionedId id) {
        return BoxesRunTime.unboxToInt((Object)this.hashFn.apply(id));
    }

    @Override
    public PartitionedConsistentHashedLoadBalancer<PartitionedId> newLoadBalancer(Set<Endpoint> endpoints) throws InvalidClusterException {
        Map partitions = (Map)endpoints.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2)new $anonfun$1(this));
        Map wheels = (Map)partitions.map((Function1)new $anonfun$2(this), Map$.MODULE$.canBuildFrom());
        int nPartitions = this.numPartitions == -1 ? ((TraversableOnce)endpoints.flatMap((Function1)new $anonfun$3(this), Set$.MODULE$.canBuildFrom())).size() : this.numPartitions;
        return new PartitionedConsistentHashedLoadBalancer<PartitionedId>(nPartitions, (Map<Integer, TreeMap<Integer, Endpoint>>)wheels, this.hashFn, this.serveRequestsIfPartitionMissing);
    }

    public PartitionedConsistentHashedLoadBalancerFactory(int numPartitions, int numReplicas, Function1<PartitionedId, Integer> hashFn, Function1<String, Integer> endpointHashFn, boolean serveRequestsIfPartitionMissing) {
        this.numPartitions = numPartitions;
        this.com$linkedin$norbert$network$partitioned$loadbalancer$PartitionedConsistentHashedLoadBalancerFactory$$numReplicas = numReplicas;
        this.hashFn = hashFn;
        this.com$linkedin$norbert$network$partitioned$loadbalancer$PartitionedConsistentHashedLoadBalancerFactory$$endpointHashFn = endpointHashFn;
        this.serveRequestsIfPartitionMissing = serveRequestsIfPartitionMissing;
        super(numPartitions, serveRequestsIfPartitionMissing);
    }
}

