/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.Publisher;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.WaitStrategy;

class SingleProducerPublisher
implements Publisher {
    private final WaitStrategy waitStrategy;
    private final Sequence cursor = new Sequence(-1L);

    public SingleProducerPublisher(WaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
    }

    @Override
    public void publish(long sequence) {
        this.cursor.set(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void ensureAvailable(long sequence) {
    }

    @Override
    public boolean isAvailable(long sequence) {
        return sequence <= this.cursor.get();
    }

    Sequence getCursorSequence() {
        return this.cursor;
    }
}

