/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.models.Collections;
import com.mangofactory.swagger.models.ModelContext;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.Types;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.property.ModelProperty;
import com.mangofactory.swagger.models.property.provider.ModelPropertiesProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ModelDependencyProvider {
    private final TypeResolver typeResolver;
    private final AlternateTypeProvider alternateTypeProvider;
    private final ModelPropertiesProvider propertiesProvider;

    @Autowired
    public ModelDependencyProvider(TypeResolver typeResolver, AlternateTypeProvider alternateTypeProvider, @Qualifier(value="default") ModelPropertiesProvider propertiesProvider) {
        this.typeResolver = typeResolver;
        this.alternateTypeProvider = alternateTypeProvider;
        this.propertiesProvider = propertiesProvider;
    }

    public Set<ResolvedType> dependentModels(ModelContext modelContext) {
        return FluentIterable.from(this.resolvedDependencies(modelContext)).filter(this.ignorableTypes(modelContext)).filter(this.baseTypes()).toSet();
    }

    private Predicate<ResolvedType> baseTypes() {
        return new Predicate<ResolvedType>(){

            public boolean apply(ResolvedType resolvedType) {
                return !Types.isBaseType(ResolvedTypes.typeName(resolvedType));
            }
        };
    }

    private Predicate<ResolvedType> ignorableTypes(final ModelContext modelContext) {
        return new Predicate<ResolvedType>(){

            public boolean apply(ResolvedType input) {
                return !modelContext.hasSeenBefore(input);
            }
        };
    }

    private List<ResolvedType> resolvedDependencies(ModelContext modelContext) {
        ResolvedType resolvedType = this.alternateTypeProvider.alternateFor(modelContext.resolvedType(this.typeResolver));
        if (Types.isBaseType(ResolvedTypes.typeName(resolvedType))) {
            modelContext.seen(resolvedType);
            return Lists.newArrayList();
        }
        ArrayList dependencies = Lists.newArrayList(this.resolvedTypeParameters(modelContext, resolvedType));
        dependencies.addAll(this.resolvedPropertiesAndFields(modelContext, resolvedType));
        return dependencies;
    }

    private List<? extends ResolvedType> resolvedTypeParameters(ModelContext modelContext, ResolvedType resolvedType) {
        ArrayList parameters = Lists.newArrayList();
        for (ResolvedType parameter : resolvedType.getTypeParameters()) {
            parameters.add(this.alternateTypeProvider.alternateFor(parameter));
            parameters.addAll(this.resolvedDependencies(ModelContext.fromParent(modelContext, parameter)));
        }
        return parameters;
    }

    private List<ResolvedType> resolvedPropertiesAndFields(ModelContext modelContext, ResolvedType resolvedType) {
        if (modelContext.hasSeenBefore(resolvedType)) {
            return Lists.newArrayList();
        }
        modelContext.seen(resolvedType);
        ArrayList properties = Lists.newArrayList();
        for (ModelProperty modelProperty : this.propertiesFor(modelContext, resolvedType)) {
            if (Types.typeNameFor(modelProperty.getType().getErasedType()) != null || Types.isBaseType(ResolvedTypes.typeName(modelProperty.getType()))) continue;
            properties.add(modelProperty.getType());
            if (Collections.isContainerType(modelProperty.getType())) {
                ResolvedType collectionElementType = Collections.collectionElementType(modelProperty.getType());
                if (Types.typeNameFor(collectionElementType.getErasedType()) != null) continue;
                if (!Types.isBaseType(ResolvedTypes.typeName(collectionElementType))) {
                    properties.add(collectionElementType);
                }
                properties.addAll(this.resolvedDependencies(ModelContext.fromParent(modelContext, collectionElementType)));
                continue;
            }
            properties.addAll(this.resolvedDependencies(ModelContext.fromParent(modelContext, modelProperty.getType())));
        }
        return properties;
    }

    private Iterable<? extends ModelProperty> propertiesFor(ModelContext modelContext, ResolvedType resolvedType) {
        if (modelContext.isReturnType()) {
            return this.propertiesProvider.propertiesForSerialization(resolvedType);
        }
        return this.propertiesProvider.propertiesForDeserialization(resolvedType);
    }
}

