/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.dto.Authorization;
import com.mangofactory.swagger.models.dto.AuthorizationScope;
import com.mangofactory.swagger.models.dto.DataType;
import com.mangofactory.swagger.models.dto.Parameter;
import com.mangofactory.swagger.models.dto.ResponseMessage;
import com.mangofactory.swagger.models.dto.SwaggerDataType;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonPropertyOrder(value={"method", "summary", "notes", "type", "nickname", "produces", "consumes", "parameters", "responseMessages", "deprecated"})
public class Operation {
    private final String method;
    private final String summary;
    private final String notes;
    @JsonIgnore
    private final String responseClass;
    @JsonProperty
    @JsonUnwrapped
    private final SwaggerDataType dataType;
    private final String nickname;
    @JsonIgnore
    private final int position;
    private final List<String> produces;
    private final List<String> consumes;
    @JsonIgnore
    private final List<String> protocol;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, List<AuthorizationScope>> authorizations;
    private final List<Parameter> parameters;
    private final Set<ResponseMessage> responseMessages;
    private final String deprecated;

    public Operation(String method, String summary, String notes, String responseClass, String nickname, int position, List<String> produces, List<String> consumes, List<String> protocol, List<Authorization> authorizations, List<Parameter> parameters, Set<ResponseMessage> responseMessages, String deprecated) {
        this.method = method;
        this.summary = summary;
        this.notes = notes;
        this.responseClass = responseClass;
        this.dataType = new DataType(responseClass);
        this.nickname = nickname;
        this.position = position;
        this.produces = produces;
        this.consumes = consumes;
        this.protocol = protocol;
        this.authorizations = this.toAuthorizationsMap(authorizations);
        this.parameters = parameters;
        this.responseMessages = responseMessages;
        this.deprecated = deprecated;
    }

    private Map<String, List<AuthorizationScope>> toAuthorizationsMap(List<Authorization> authorizations) {
        return Maps.transformEntries((Map)Maps.uniqueIndex(authorizations, this.byType()), this.toScopes());
    }

    private Maps.EntryTransformer<? super String, ? super Authorization, List<AuthorizationScope>> toScopes() {
        return new Maps.EntryTransformer<String, Authorization, List<AuthorizationScope>>(){

            public List<AuthorizationScope> transformEntry(String key, Authorization value) {
                return Lists.newArrayList((Object[])value.getScopes());
            }
        };
    }

    private Function<? super Authorization, String> byType() {
        return new Function<Authorization, String>(){

            public String apply(Authorization input) {
                return input.getType();
            }
        };
    }

    public String getMethod() {
        return this.method;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getResponseClass() {
        return this.responseClass;
    }

    public String getNickname() {
        return this.nickname;
    }

    public int getPosition() {
        return this.position;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public List<String> getProtocol() {
        return this.protocol;
    }

    public Map<String, List<AuthorizationScope>> getAuthorizations() {
        return this.authorizations;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Set<ResponseMessage> getResponseMessages() {
        return this.responseMessages;
    }

    public String getDeprecated() {
        return this.deprecated;
    }
}

