/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.ProfileUpdateParameters;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.ProfileInner;
import com.microsoft.azure.management.cdn.implementation.ResourceUsageInner;
import com.microsoft.azure.management.cdn.implementation.SsoUriInner;
import com.microsoft.azure.management.cdn.implementation.SupportedOptimizationTypesListResultInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ProfilesInner
implements InnerSupportsGet<ProfileInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ProfileInner> {
    private ProfilesService service;
    private CdnManagementClientImpl client;

    public ProfilesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (ProfilesService)retrofit.create(ProfilesService.class);
        this.client = client;
    }

    public PagedList<ProfileInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ProfileInner>((Page)response.body()){

            public Page<ProfileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProfilesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProfileInner>> listAsync(ListOperationCallback<ProfileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(String nextPageLink) {
                return ProfilesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProfileInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ProfileInner>>, Page<ProfileInner>>(){

            public Page<ProfileInner> call(ServiceResponse<Page<ProfileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProfileInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ProfileInner>>, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(ServiceResponse<Page<ProfileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProfilesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProfileInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProfilesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProfileInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProfileInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ProfileInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ProfileInner>((Page)response.body()){

            public Page<ProfileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProfilesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProfileInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ProfileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(String nextPageLink) {
                return ProfilesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProfileInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ProfileInner>>, Page<ProfileInner>>(){

            public Page<ProfileInner> call(ServiceResponse<Page<ProfileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProfileInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ProfileInner>>, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(ServiceResponse<Page<ProfileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProfilesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProfileInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProfilesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProfileInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProfileInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ProfileInner getByResourceGroup(String resourceGroupName, String profileName) {
        return (ProfileInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body());
    }

    public ServiceFuture<ProfileInner> getByResourceGroupAsync(String resourceGroupName, String profileName, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<ProfileInner> getByResourceGroupAsync(String resourceGroupName, String profileName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProfileInner>>>(){

            public Observable<ServiceResponse<ProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProfileInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProfileInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ProfileInner create(String resourceGroupName, String profileName, ProfileInner profile) {
        return (ProfileInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, profile).toBlocking().last()).body());
    }

    public ServiceFuture<ProfileInner> createAsync(String resourceGroupName, String profileName, ProfileInner profile, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, profile), serviceCallback);
    }

    public Observable<ProfileInner> createAsync(String resourceGroupName, String profileName, ProfileInner profile) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, profile).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, ProfileInner profile) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (profile == null) {
            throw new IllegalArgumentException("Parameter profile is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)profile));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, this.client.subscriptionId(), profile, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ProfileInner>(){}.getType());
    }

    public ProfileInner beginCreate(String resourceGroupName, String profileName, ProfileInner profile) {
        return (ProfileInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, profile).toBlocking().single()).body());
    }

    public ServiceFuture<ProfileInner> beginCreateAsync(String resourceGroupName, String profileName, ProfileInner profile, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, profile), serviceCallback);
    }

    public Observable<ProfileInner> beginCreateAsync(String resourceGroupName, String profileName, ProfileInner profile) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, profile).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, ProfileInner profile) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (profile == null) {
            throw new IllegalArgumentException("Parameter profile is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)profile));
        return this.service.beginCreate(resourceGroupName, profileName, this.client.subscriptionId(), profile, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProfileInner>>>(){

            public Observable<ServiceResponse<ProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProfileInner> beginCreateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProfileInner>(){}.getType()).register(201, new TypeToken<ProfileInner>(){}.getType()).register(202, new TypeToken<ProfileInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ProfileInner update(String resourceGroupName, String profileName) {
        return (ProfileInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().last()).body());
    }

    public ServiceFuture<ProfileInner> updateAsync(String resourceGroupName, String profileName, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<ProfileInner> updateAsync(String resourceGroupName, String profileName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tags = null;
        ProfileUpdateParameters profileUpdateParameters = new ProfileUpdateParameters();
        profileUpdateParameters.withTags(null);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), profileUpdateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ProfileInner>(){}.getType());
    }

    public ProfileInner update(String resourceGroupName, String profileName, Map<String, String> tags) {
        return (ProfileInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, tags).toBlocking().last()).body());
    }

    public ServiceFuture<ProfileInner> updateAsync(String resourceGroupName, String profileName, Map<String, String> tags, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, tags), serviceCallback);
    }

    public Observable<ProfileInner> updateAsync(String resourceGroupName, String profileName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, tags).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        ProfileUpdateParameters profileUpdateParameters = new ProfileUpdateParameters();
        profileUpdateParameters.withTags(tags);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), profileUpdateParameters, this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ProfileInner>(){}.getType());
    }

    public ProfileInner beginUpdate(String resourceGroupName, String profileName) {
        return (ProfileInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body());
    }

    public ServiceFuture<ProfileInner> beginUpdateAsync(String resourceGroupName, String profileName, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<ProfileInner> beginUpdateAsync(String resourceGroupName, String profileName) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tags = null;
        ProfileUpdateParameters profileUpdateParameters = new ProfileUpdateParameters();
        profileUpdateParameters.withTags(null);
        return this.service.beginUpdate(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), profileUpdateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProfileInner>>>(){

            public Observable<ServiceResponse<ProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ProfileInner beginUpdate(String resourceGroupName, String profileName, Map<String, String> tags) {
        return (ProfileInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<ProfileInner> beginUpdateAsync(String resourceGroupName, String profileName, Map<String, String> tags, ServiceCallback<ProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, tags), serviceCallback);
    }

    public Observable<ProfileInner> beginUpdateAsync(String resourceGroupName, String profileName, Map<String, String> tags) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, tags).map((Func1)new Func1<ServiceResponse<ProfileInner>, ProfileInner>(){

            public ProfileInner call(ServiceResponse<ProfileInner> response) {
                return (ProfileInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ProfileInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        ProfileUpdateParameters profileUpdateParameters = new ProfileUpdateParameters();
        profileUpdateParameters.withTags(tags);
        return this.service.beginUpdate(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), profileUpdateParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProfileInner>>>(){

            public Observable<ServiceResponse<ProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProfileInner> beginUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProfileInner>(){}.getType()).register(202, new TypeToken<ProfileInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public SsoUriInner generateSsoUri(String resourceGroupName, String profileName) {
        return (SsoUriInner)((ServiceResponse)this.generateSsoUriWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body();
    }

    public ServiceFuture<SsoUriInner> generateSsoUriAsync(String resourceGroupName, String profileName, ServiceCallback<SsoUriInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.generateSsoUriWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<SsoUriInner> generateSsoUriAsync(String resourceGroupName, String profileName) {
        return this.generateSsoUriWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<SsoUriInner>, SsoUriInner>(){

            public SsoUriInner call(ServiceResponse<SsoUriInner> response) {
                return (SsoUriInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SsoUriInner>> generateSsoUriWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.generateSsoUri(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SsoUriInner>>>(){

            public Observable<ServiceResponse<SsoUriInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.generateSsoUriDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SsoUriInner> generateSsoUriDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SsoUriInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public SupportedOptimizationTypesListResultInner listSupportedOptimizationTypes(String resourceGroupName, String profileName) {
        return (SupportedOptimizationTypesListResultInner)((ServiceResponse)this.listSupportedOptimizationTypesWithServiceResponseAsync(resourceGroupName, profileName).toBlocking().single()).body();
    }

    public ServiceFuture<SupportedOptimizationTypesListResultInner> listSupportedOptimizationTypesAsync(String resourceGroupName, String profileName, ServiceCallback<SupportedOptimizationTypesListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSupportedOptimizationTypesWithServiceResponseAsync(resourceGroupName, profileName), serviceCallback);
    }

    public Observable<SupportedOptimizationTypesListResultInner> listSupportedOptimizationTypesAsync(String resourceGroupName, String profileName) {
        return this.listSupportedOptimizationTypesWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<SupportedOptimizationTypesListResultInner>, SupportedOptimizationTypesListResultInner>(){

            public SupportedOptimizationTypesListResultInner call(ServiceResponse<SupportedOptimizationTypesListResultInner> response) {
                return (SupportedOptimizationTypesListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SupportedOptimizationTypesListResultInner>> listSupportedOptimizationTypesWithServiceResponseAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listSupportedOptimizationTypes(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SupportedOptimizationTypesListResultInner>>>(){

            public Observable<ServiceResponse<SupportedOptimizationTypesListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProfilesInner.this.listSupportedOptimizationTypesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SupportedOptimizationTypesListResultInner> listSupportedOptimizationTypesDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SupportedOptimizationTypesListResultInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ResourceUsageInner> listResourceUsage(String resourceGroupName, String profileName) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<ResourceUsageInner>((Page)response.body()){

            public Page<ResourceUsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProfilesInner.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceUsageInner>> listResourceUsageAsync(String resourceGroupName, String profileName, ListOperationCallback<ResourceUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageSinglePageAsync(resourceGroupName, profileName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(String nextPageLink) {
                return ProfilesInner.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceUsageInner>> listResourceUsageAsync(String resourceGroupName, String profileName) {
        return this.listResourceUsageWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Page<ResourceUsageInner>>(){

            public Page<ResourceUsageInner> call(ServiceResponse<Page<ResourceUsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageWithServiceResponseAsync(String resourceGroupName, String profileName) {
        return this.listResourceUsageSinglePageAsync(resourceGroupName, profileName).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(ServiceResponse<Page<ResourceUsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProfilesInner.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listResourceUsage(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProfilesInner.this.listResourceUsageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceUsageInner>> listResourceUsageDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceUsageInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ProfileInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProfileInner>((Page)response.body()){

            public Page<ProfileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProfilesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProfileInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ProfileInner>> serviceFuture, ListOperationCallback<ProfileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(String nextPageLink) {
                return ProfilesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProfileInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ProfileInner>>, Page<ProfileInner>>(){

            public Page<ProfileInner> call(ServiceResponse<Page<ProfileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProfileInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ProfileInner>>, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(ServiceResponse<Page<ProfileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProfilesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProfileInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProfilesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProfileInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProfileInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ProfileInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProfileInner>((Page)response.body()){

            public Page<ProfileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProfilesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProfileInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ProfileInner>> serviceFuture, ListOperationCallback<ProfileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(String nextPageLink) {
                return ProfilesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProfileInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ProfileInner>>, Page<ProfileInner>>(){

            public Page<ProfileInner> call(ServiceResponse<Page<ProfileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProfileInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ProfileInner>>, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(ServiceResponse<Page<ProfileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProfilesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProfileInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProfileInner>>>>(){

            public Observable<ServiceResponse<Page<ProfileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProfilesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProfileInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProfileInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ResourceUsageInner> listResourceUsageNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceUsageInner>((Page)response.body()){

            public Page<ResourceUsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProfilesInner.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceUsageInner>> listResourceUsageNextAsync(String nextPageLink, ServiceFuture<List<ResourceUsageInner>> serviceFuture, ListOperationCallback<ResourceUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(String nextPageLink) {
                return ProfilesInner.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceUsageInner>> listResourceUsageNextAsync(String nextPageLink) {
        return this.listResourceUsageNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Page<ResourceUsageInner>>(){

            public Page<ResourceUsageInner> call(ServiceResponse<Page<ResourceUsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageNextWithServiceResponseAsync(String nextPageLink) {
        return this.listResourceUsageNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(ServiceResponse<Page<ResourceUsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProfilesInner.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listResourceUsageNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProfilesInner.this.listResourceUsageNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceUsageInner>> listResourceUsageNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceUsageInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface ProfilesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Cdn/profiles")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Body ProfileInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Body ProfileInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body ProfileUpdateParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body ProfileUpdateParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles generateSsoUri"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/generateSsoUri")
        public Observable<Response<ResponseBody>> generateSsoUri(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles listSupportedOptimizationTypes"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/getSupportedOptimizationTypes")
        public Observable<Response<ResponseBody>> listSupportedOptimizationTypes(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles listResourceUsage"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/checkResourceUsage")
        public Observable<Response<ResponseBody>> listResourceUsage(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Profiles listResourceUsageNext"})
        @GET
        public Observable<Response<ResponseBody>> listResourceUsageNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

