/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.VirtualMachineImage;
import com.microsoft.azure.management.compute.VirtualMachineImagesInSku;
import com.microsoft.azure.management.compute.VirtualMachineSku;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageImpl;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImageResourceInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImagesInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.rest.RestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class VirtualMachineImagesInSkuImpl
implements VirtualMachineImagesInSku {
    private final VirtualMachineImagesInner innerCollection;
    private final VirtualMachineSku sku;

    VirtualMachineImagesInSkuImpl(VirtualMachineSku sku, VirtualMachineImagesInner innerCollection) {
        this.sku = sku;
        this.innerCollection = innerCollection;
    }

    public PagedList<VirtualMachineImage> list() {
        final ArrayList<VirtualMachineImageImpl> images = new ArrayList<VirtualMachineImageImpl>();
        for (VirtualMachineImageResourceInner inner : this.innerCollection.list(this.sku.region().toString(), this.sku.publisher().name(), this.sku.offer().name(), this.sku.name())) {
            String version = inner.name();
            images.add(new VirtualMachineImageImpl(this.sku.region(), this.sku.publisher().name(), this.sku.offer().name(), this.sku.name(), version, this.innerCollection.get(this.sku.region().toString(), this.sku.publisher().name(), this.sku.offer().name(), this.sku.name(), version)));
        }
        Page<VirtualMachineImage> page = new Page<VirtualMachineImage>(){

            public String nextPageLink() {
                return null;
            }

            public List<VirtualMachineImage> items() {
                return images;
            }
        };
        return new PagedList<VirtualMachineImage>((Page)page){

            public Page<VirtualMachineImage> nextPage(String nextPageLink) throws RestException, IOException {
                return null;
            }
        };
    }

    public Observable<VirtualMachineImage> listAsync() {
        final VirtualMachineImagesInSkuImpl self = this;
        return ReadableWrappersImpl.convertListToInnerAsync(this.innerCollection.listAsync(this.sku.region().toString(), this.sku.publisher().name(), this.sku.offer().name(), this.sku.name())).flatMap((Func1)new Func1<VirtualMachineImageResourceInner, Observable<VirtualMachineImage>>(){

            public Observable<VirtualMachineImage> call(final VirtualMachineImageResourceInner virtualMachineImageResourceInner) {
                return VirtualMachineImagesInSkuImpl.this.innerCollection.getAsync(self.sku.region().toString(), self.sku.publisher().name(), self.sku.offer().name(), self.sku.name(), virtualMachineImageResourceInner.name()).map((Func1)new Func1<VirtualMachineImageInner, VirtualMachineImage>(){

                    public VirtualMachineImage call(VirtualMachineImageInner virtualMachineImageInner) {
                        return new VirtualMachineImageImpl(self.sku.region(), self.sku.publisher().name(), self.sku.offer().name(), self.sku.name(), virtualMachineImageResourceInner.name(), virtualMachineImageInner);
                    }
                });
            }
        });
    }
}

