/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.p2p.solanaj.core.AccountMeta;

public class AccountKeysList {
    private HashMap<String, AccountMeta> accounts = new HashMap();
    private static final Comparator<AccountMeta> metaComparator = new Comparator<AccountMeta>(){

        @Override
        public int compare(AccountMeta am1, AccountMeta am2) {
            int cmpkWritable;
            int cmpSigner;
            int n = am1.isSigner() == am2.isSigner() ? 0 : (cmpSigner = am1.isSigner() ? -1 : 1);
            if (cmpSigner != 0) {
                return cmpSigner;
            }
            int n2 = am1.isWritable() == am2.isWritable() ? 0 : (cmpkWritable = am1.isWritable() ? -1 : 1);
            if (cmpkWritable != 0) {
                return cmpkWritable;
            }
            return Integer.compare(cmpSigner, cmpkWritable);
        }
    };

    public void add(AccountMeta accountMeta) {
        String key = accountMeta.getPublicKey().toString();
        if (this.accounts.containsKey(key)) {
            if (!this.accounts.get(key).isWritable() && accountMeta.isWritable()) {
                this.accounts.put(key, accountMeta);
            }
        } else {
            this.accounts.put(key, accountMeta);
        }
    }

    public void addAll(Collection<AccountMeta> metas) {
        for (AccountMeta meta : metas) {
            this.add(meta);
        }
    }

    public ArrayList<AccountMeta> getList() {
        ArrayList<AccountMeta> accountKeysList = new ArrayList<AccountMeta>(this.accounts.values());
        accountKeysList.sort(metaComparator);
        return accountKeysList;
    }
}

