/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Sha256Hash;
import org.p2p.solanaj.utils.ByteUtils;
import org.p2p.solanaj.utils.PublicKeySerializer;
import org.p2p.solanaj.utils.TweetNaclFast;

@JsonSerialize(using=PublicKeySerializer.class)
public class PublicKey {
    public static final int PUBLIC_KEY_LENGTH = 32;
    private byte[] pubkey;

    public PublicKey(String pubkey) {
        if (pubkey.length() < 32) {
            throw new IllegalArgumentException("Invalid public key input");
        }
        this.pubkey = Base58.decode((String)pubkey);
    }

    public PublicKey(byte[] pubkey) {
        if (pubkey.length > 32) {
            throw new IllegalArgumentException("Invalid public key input");
        }
        this.pubkey = pubkey;
    }

    public static PublicKey readPubkey(byte[] bytes, int offset) {
        byte[] buf = ByteUtils.readBytes(bytes, offset, 32);
        return new PublicKey(buf);
    }

    public byte[] toByteArray() {
        return this.pubkey;
    }

    public String toBase58() {
        return Base58.encode((byte[])this.pubkey);
    }

    public boolean equals(PublicKey pubkey) {
        return Arrays.equals(this.pubkey, pubkey.toByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.pubkey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        PublicKey person = (PublicKey)o;
        return this.equals(person);
    }

    public String toString() {
        return this.toBase58();
    }

    public static PublicKey createProgramAddress(List<byte[]> seeds, PublicKey programId) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (byte[] seed : seeds) {
            if (seed.length > 32) {
                throw new IllegalArgumentException("Max seed length exceeded");
            }
            buffer.writeBytes(seed);
        }
        buffer.writeBytes(programId.toByteArray());
        buffer.writeBytes("ProgramDerivedAddress".getBytes());
        byte[] hash = Sha256Hash.hash((byte[])buffer.toByteArray());
        if (TweetNaclFast.is_on_curve(hash) != 0) {
            throw new RuntimeException("Invalid seeds, address must fall off the curve");
        }
        return new PublicKey(hash);
    }

    public static ProgramDerivedAddress findProgramAddress(List<byte[]> seeds, PublicKey programId) throws Exception {
        ArrayList<byte[]> seedsWithNonce = new ArrayList<byte[]>();
        seedsWithNonce.addAll(seeds);
        for (int nonce = 255; nonce != 0; --nonce) {
            PublicKey address;
            try {
                seedsWithNonce.add(new byte[]{(byte)nonce});
                address = PublicKey.createProgramAddress(seedsWithNonce, programId);
            }
            catch (Exception e) {
                seedsWithNonce.remove(seedsWithNonce.size() - 1);
                continue;
            }
            return new ProgramDerivedAddress(address, nonce);
        }
        throw new Exception("Unable to find a viable program address nonce");
    }

    public static PublicKey valueOf(String publicKey) {
        return new PublicKey(publicKey);
    }

    public static class ProgramDerivedAddress {
        private PublicKey address;
        private int nonce;

        public ProgramDerivedAddress(PublicKey address, int nonce) {
            this.address = address;
            this.nonce = nonce;
        }

        public PublicKey getAddress() {
            return this.address;
        }

        public int getNonce() {
            return this.nonce;
        }
    }
}

