/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bitcoinj.core.Base58;
import org.p2p.solanaj.core.Account;
import org.p2p.solanaj.core.Message;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.utils.ShortvecEncoding;
import org.p2p.solanaj.utils.TweetNaclFast;

public class Transaction {
    public static final int SIGNATURE_LENGTH = 64;
    private Message message = new Message();
    private List<String> signatures = new ArrayList<String>();
    private byte[] serializedMessage;

    public Transaction addInstruction(TransactionInstruction instruction) {
        this.message.addInstruction(instruction);
        return this;
    }

    public void setRecentBlockHash(String recentBlockhash) {
        this.message.setRecentBlockHash(recentBlockhash);
    }

    public void sign(Account signer) {
        this.sign(Arrays.asList(signer));
    }

    public void sign(List<Account> signers) {
        if (signers.size() == 0) {
            throw new IllegalArgumentException("No signers");
        }
        Account feePayer = signers.get(0);
        this.message.setFeePayer(feePayer);
        this.serializedMessage = this.message.serialize();
        for (Account signer : signers) {
            TweetNaclFast.Signature signatureProvider = new TweetNaclFast.Signature(new byte[0], signer.getSecretKey());
            byte[] signature = signatureProvider.detached(this.serializedMessage);
            this.signatures.add(Base58.encode((byte[])signature));
        }
    }

    public byte[] serialize() {
        int signaturesSize = this.signatures.size();
        byte[] signaturesLength = ShortvecEncoding.encodeLength(signaturesSize);
        ByteBuffer out = ByteBuffer.allocate(signaturesLength.length + signaturesSize * 64 + this.serializedMessage.length);
        out.put(signaturesLength);
        for (String signature : this.signatures) {
            byte[] rawSignature = Base58.decode((String)signature);
            out.put(rawSignature);
        }
        out.put(this.serializedMessage);
        return out.array();
    }
}

