/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.programs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.programs.Program;
import org.p2p.solanaj.programs.SystemProgram;
import org.p2p.solanaj.programs.TokenProgram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociatedTokenProgram
extends Program {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AssociatedTokenProgram.class);
    public static final PublicKey PROGRAM_ID = new PublicKey("ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL");
    private static final int CREATE_IDEMPOTENT_METHOD_ID = 1;

    public static TransactionInstruction createIdempotent(PublicKey fundingAccount, PublicKey walletAddress, PublicKey mint) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        PublicKey pda = null;
        try {
            pda = PublicKey.findProgramAddress(List.of(walletAddress.toByteArray(), TokenProgram.PROGRAM_ID.toByteArray(), mint.toByteArray()), PROGRAM_ID).getAddress();
            log.info("ATA: {}", (Object)pda.toBase58());
        }
        catch (Exception e) {
            log.error("Error finding ATA: {}", (Object)e.getMessage());
        }
        keys.add(new AccountMeta(fundingAccount, true, true));
        keys.add(new AccountMeta(pda, false, true));
        keys.add(new AccountMeta(fundingAccount, false, false));
        keys.add(new AccountMeta(mint, false, false));
        keys.add(new AccountMeta(SystemProgram.PROGRAM_ID, false, false));
        keys.add(new AccountMeta(TokenProgram.PROGRAM_ID, false, false));
        byte[] transactionData = AssociatedTokenProgram.encodeTransferTokenInstructionData();
        return AssociatedTokenProgram.createTransactionInstruction(PROGRAM_ID, keys, transactionData);
    }

    private static byte[] encodeTransferTokenInstructionData() {
        ByteBuffer result = ByteBuffer.allocate(1);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)1);
        return result.array();
    }
}

