/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.rpc;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLHandshakeException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.p2p.solanaj.rpc.Cluster;
import org.p2p.solanaj.rpc.RpcApi;
import org.p2p.solanaj.rpc.RpcException;
import org.p2p.solanaj.rpc.WeightedCluster;
import org.p2p.solanaj.rpc.types.RpcRequest;
import org.p2p.solanaj.rpc.types.RpcResponse;
import org.p2p.solanaj.rpc.types.WeightedEndpoint;

public class RpcClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String endpoint;
    private OkHttpClient httpClient;
    private RpcApi rpcApi;
    private WeightedCluster cluster;

    public RpcClient(WeightedCluster cluster) {
        this.cluster = cluster;
    }

    public RpcClient(Cluster endpoint) {
        this(endpoint.getEndpoint());
    }

    public RpcClient(String endpoint) {
        this.endpoint = endpoint;
        this.httpClient = new OkHttpClient.Builder().readTimeout(20L, TimeUnit.SECONDS).build();
        this.rpcApi = new RpcApi(this);
    }

    public RpcClient(String endpoint, String userAgent) {
        this.endpoint = endpoint;
        this.httpClient = new OkHttpClient.Builder().addNetworkInterceptor(chain -> chain.proceed(chain.request().newBuilder().header("User-Agent", userAgent).build())).readTimeout(20L, TimeUnit.SECONDS).build();
        this.rpcApi = new RpcApi(this);
    }

    public RpcClient(String endpoint, int timeout) {
        this.endpoint = endpoint;
        this.httpClient = new OkHttpClient.Builder().readTimeout((long)timeout, TimeUnit.SECONDS).build();
        this.rpcApi = new RpcApi(this);
    }

    public RpcClient(String endpoint, int readTimeoutMs, int connectTimeoutMs, int writeTimeoutMs) {
        this.endpoint = endpoint;
        this.httpClient = new OkHttpClient.Builder().readTimeout((long)readTimeoutMs, TimeUnit.MILLISECONDS).connectTimeout((long)connectTimeoutMs, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeoutMs, TimeUnit.MILLISECONDS).build();
        this.rpcApi = new RpcApi(this);
    }

    public <T> T call(String method, List<Object> params, Class<T> clazz) throws RpcException {
        RpcRequest rpcRequest = new RpcRequest(method, params);
        JsonAdapter rpcRequestJsonAdapter = new Moshi.Builder().build().adapter(RpcRequest.class);
        JsonAdapter resultAdapter = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(RpcResponse.class, (Type[])new Type[]{(Type)Type.class.cast(clazz)}));
        Request request = new Request.Builder().url(this.getEndpoint()).post(RequestBody.create((String)rpcRequestJsonAdapter.toJson((Object)rpcRequest), (MediaType)JSON)).build();
        try {
            Response response = this.httpClient.newCall(request).execute();
            String result = response.body().string();
            RpcResponse rpcResult = (RpcResponse)resultAdapter.fromJson(result);
            if (rpcResult.getError() != null) {
                throw new RpcException(rpcResult.getError().getMessage());
            }
            return rpcResult.getResult();
        }
        catch (SSLHandshakeException e) {
            this.httpClient = new OkHttpClient.Builder().build();
            throw new RpcException(e.getMessage());
        }
        catch (IOException e) {
            throw new RpcException(e.getMessage());
        }
    }

    public RpcApi getApi() {
        return this.rpcApi;
    }

    public String getEndpoint() {
        if (this.cluster != null) {
            return this.getWeightedEndpoint();
        }
        return this.endpoint;
    }

    private String getWeightedEndpoint() {
        int currentNumber = 0;
        int randomMultiplier = this.cluster.endpoints.stream().mapToInt(WeightedEndpoint::getWeight).sum();
        double randomNumber = Math.random() * (double)randomMultiplier;
        String currentEndpoint = "";
        for (WeightedEndpoint endpoint : this.cluster.endpoints) {
            if (randomNumber > (double)(currentNumber + endpoint.getWeight())) {
                currentNumber += endpoint.getWeight().intValue();
                continue;
            }
            if (!(randomNumber >= (double)currentNumber) || !(randomNumber <= (double)(currentNumber + endpoint.getWeight()))) continue;
            return endpoint.getUrl();
        }
        return currentEndpoint;
    }
}

