/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.ws;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.p2p.solanaj.rpc.types.RpcNotificationResult;
import org.p2p.solanaj.rpc.types.RpcRequest;
import org.p2p.solanaj.rpc.types.RpcResponse;
import org.p2p.solanaj.rpc.types.config.Commitment;
import org.p2p.solanaj.ws.SignatureNotification;
import org.p2p.solanaj.ws.listeners.NotificationEventListener;

public class SubscriptionWebSocketClient
extends WebSocketClient {
    private Map<String, SubscriptionParams> subscriptions = new ConcurrentHashMap<String, SubscriptionParams>();
    private Map<String, Long> subscriptionIds = new ConcurrentHashMap<String, Long>();
    private Map<Long, NotificationEventListener> subscriptionListeners = new ConcurrentHashMap<Long, NotificationEventListener>();
    private static final Logger LOGGER = Logger.getLogger(SubscriptionWebSocketClient.class.getName());

    public static SubscriptionWebSocketClient getExactPathInstance(String endpoint) {
        URI serverURI;
        try {
            serverURI = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        SubscriptionWebSocketClient instance = new SubscriptionWebSocketClient(serverURI);
        if (!instance.isOpen()) {
            instance.connect();
        }
        return instance;
    }

    public static SubscriptionWebSocketClient getInstance(String endpoint) {
        URI serverURI;
        try {
            URI endpointURI = new URI(endpoint);
            serverURI = new URI((String)(endpointURI.getScheme() == "https" ? "wss" : "ws://" + endpointURI.getHost()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        SubscriptionWebSocketClient instance = new SubscriptionWebSocketClient(serverURI);
        if (!instance.isOpen()) {
            instance.connect();
        }
        return instance;
    }

    public SubscriptionWebSocketClient(URI serverURI) {
        super(serverURI);
    }

    public void accountSubscribe(String key, NotificationEventListener listener) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(Map.of("encoding", "jsonParsed", "commitment", Commitment.PROCESSED.getValue()));
        RpcRequest rpcRequest = new RpcRequest("accountSubscribe", params);
        this.subscriptions.put(rpcRequest.getId(), new SubscriptionParams(rpcRequest, listener));
        this.subscriptionIds.put(rpcRequest.getId(), 0L);
        this.updateSubscriptions();
    }

    public void signatureSubscribe(String signature, NotificationEventListener listener) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(signature);
        RpcRequest rpcRequest = new RpcRequest("signatureSubscribe", params);
        this.subscriptions.put(rpcRequest.getId(), new SubscriptionParams(rpcRequest, listener));
        this.subscriptionIds.put(rpcRequest.getId(), 0L);
        this.updateSubscriptions();
    }

    public void logsSubscribe(String mention, NotificationEventListener listener) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Map.of("mentions", List.of(mention)));
        params.add(Map.of("commitment", "finalized"));
        RpcRequest rpcRequest = new RpcRequest("logsSubscribe", params);
        this.subscriptions.put(rpcRequest.getId(), new SubscriptionParams(rpcRequest, listener));
        this.subscriptionIds.put(rpcRequest.getId(), 0L);
        this.updateSubscriptions();
    }

    public void logsSubscribe(List<String> mentions, NotificationEventListener listener) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Map.of("mentions", mentions));
        params.add(Map.of("commitment", "finalized"));
        RpcRequest rpcRequest = new RpcRequest("logsSubscribe", params);
        this.subscriptions.put(rpcRequest.getId(), new SubscriptionParams(rpcRequest, listener));
        this.subscriptionIds.put(rpcRequest.getId(), null);
        this.updateSubscriptions();
    }

    public void onOpen(ServerHandshake handshakedata) {
        LOGGER.info("Websocket connection opened");
        this.updateSubscriptions();
    }

    public void onMessage(String message) {
        JsonAdapter resultAdapter = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(RpcResponse.class, (Type[])new Type[]{Long.class}));
        try {
            RpcResponse rpcResult = (RpcResponse)resultAdapter.fromJson(message);
            String rpcResultId = rpcResult.getId();
            if (rpcResultId != null) {
                if (this.subscriptionIds.containsKey(rpcResultId)) {
                    try {
                        this.subscriptionIds.put(rpcResultId, (Long)rpcResult.getResult());
                        this.subscriptionListeners.put((Long)rpcResult.getResult(), this.subscriptions.get((Object)rpcResultId).listener);
                        this.subscriptions.remove(rpcResultId);
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            } else {
                JsonAdapter notificationResultAdapter = new Moshi.Builder().build().adapter(RpcNotificationResult.class);
                RpcNotificationResult result = (RpcNotificationResult)notificationResultAdapter.fromJson(message);
                NotificationEventListener listener = this.subscriptionListeners.get(result.getParams().getSubscription());
                Map value = (Map)result.getParams().getResult().getValue();
                switch (result.getMethod()) {
                    case "signatureNotification": {
                        listener.onNotificationEvent(new SignatureNotification(value.get("err")));
                        break;
                    }
                    case "accountNotification": 
                    case "logsNotification": {
                        if (listener == null) break;
                        listener.onNotificationEvent(value);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        System.out.println("Connection closed by " + (remote ? "remote peer" : "us") + " Code: " + code + " Reason: " + reason);
    }

    public void onError(Exception ex) {
        ex.printStackTrace();
    }

    private void updateSubscriptions() {
        if (this.isOpen() && this.subscriptions.size() > 0) {
            JsonAdapter rpcRequestJsonAdapter = new Moshi.Builder().build().adapter(RpcRequest.class);
            for (SubscriptionParams sub : this.subscriptions.values()) {
                this.send(rpcRequestJsonAdapter.toJson((Object)sub.request));
            }
        }
    }

    private class SubscriptionParams {
        RpcRequest request;
        NotificationEventListener listener;

        SubscriptionParams(RpcRequest request, NotificationEventListener listener) {
            this.request = request;
            this.listener = listener;
        }
    }
}

