/*
 * Decompiled with CFR 0.152.
 */
package mtons.modules.lang;

import mtons.modules.exception.MtonsException;

public class Assert {
    public static void isTrue(boolean expression, int errorCode) {
        if (!expression) {
            throw new MtonsException(errorCode);
        }
    }

    public static void isFalse(boolean expression, int errorCode) {
        if (expression) {
            throw new MtonsException(errorCode);
        }
    }

    public static void isNull(Object object, int errorCode) {
        Assert.isTrue(object == null, errorCode);
    }

    public static void notNull(Object object, int errorCode) {
        Assert.isFalse(object == null, errorCode);
    }

    public static void instanceOf(Object object, Class<?> c, int errorCode) {
        Assert.isTrue(c.isInstance(object), errorCode);
    }

    public static void notInstanceOf(Object object, Class<?> c, int errorCode) {
        Assert.isFalse(c.isInstance(object), errorCode);
    }

    public static void gt(long x, long y, int errorCode) {
        Assert.isTrue(x > y, errorCode);
    }

    public static void ge(long x, long y, int errorCode) {
        Assert.isTrue(x >= y, errorCode);
    }

    public static void lt(long x, long y, int errorCode) {
        Assert.isTrue(x < y, errorCode);
    }

    public static void le(long x, long y, int errorCode) {
        Assert.isTrue(x <= y, errorCode);
    }

    public static void eq(long x, long y, int errorCode) {
        Assert.isTrue(x == y, errorCode);
    }

    public static void ne(long x, long y, int errorCode) {
        Assert.isTrue(x != y, errorCode);
    }

    public static <T> void eq(Comparable<T> x, T y, int errorCode) {
        Assert.isTrue(x.compareTo(y) == 0, errorCode);
    }

    public static <T> void ne(Comparable<T> x, T y, int errorCode) {
        Assert.isTrue(x.compareTo(y) != 0, errorCode);
    }

    public static <T> void gt(Comparable<T> x, T y, int errorCode) {
        Assert.isTrue(x.compareTo(y) == 1, errorCode);
    }

    public static <T> void ge(Comparable<T> x, T y, int errorCode) {
        Assert.isTrue(x.compareTo(y) != -1, errorCode);
    }

    public static <T> void lt(Comparable<T> x, T y, int errorCode) {
        Assert.isTrue(x.compareTo(y) == -1, errorCode);
    }

    public static <T> void le(Comparable<T> x, T y, int errorCode) {
        Assert.isTrue(x.compareTo(y) != 1, errorCode);
    }
}

