/*
 * Decompiled with CFR 0.152.
 */
package mtons.modules.persist.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import mtons.modules.annotation.Repository;
import mtons.modules.persist.BaseRepository;
import mtons.modules.persist.impl.GenericRepositoryImpl;
import mtons.modules.pojos.Paging;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.util.Assert;

public class BaseRepositoryImpl<T>
extends GenericRepositoryImpl
implements BaseRepository<T> {
    private static final long serialVersionUID = 3362415966471351147L;
    protected Class<T> entityClass;

    @PostConstruct
    public void init() throws Exception {
        Repository repository = this.getClass().getAnnotation(Repository.class);
        Assert.notNull((Object)repository, (String)(this.getClass() + " \u5fc5\u987b\u8981\u4f7f\u7528" + Repository.class + "\u6ce8\u89e3!"));
        Assert.notNull(repository.entity(), (String)(this.getClass() + " \u7684 @Repository\u6ce8\u89e3\u7684 entity \u4e0d\u80fd\u4e3a\u7a7a!"));
        this.entityClass = repository.entity();
    }

    @Override
    public void deleteById(Serializable id) {
        this.deleteById(this.entityClass, id);
    }

    @Override
    public void deleteAll(Collection<Serializable> ids) {
        Assert.notNull(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ids.forEach(id -> this.deleteById((Serializable)id));
    }

    @Override
    public T get(Serializable id) {
        return this.get(this.entityClass, id);
    }

    protected List<T> find(Criterion ... criterions) {
        return this.createCriteria(criterions).list();
    }

    protected List<T> findBy(String propertyName, Object value) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = Restrictions.eq((String)propertyName, (Object)value);
        return this.find(new Criterion[]{criterion});
    }

    protected T findUniqueBy(String propertyName, Object value) {
        Assert.hasText((String)propertyName, (String)"propertyName\u4e0d\u80fd\u4e3a\u7a7a");
        SimpleExpression criterion = Restrictions.eq((String)propertyName, (Object)value);
        return (T)this.createCriteria(new Criterion[]{criterion}).uniqueResult();
    }

    protected T findUnique(String hql, Object ... values) {
        return (T)this.createQuery(hql, values).uniqueResult();
    }

    protected T findFirst(Criterion ... criterions) {
        List<T> rets = this.find(criterions);
        if (rets != null && rets.size() > 0) {
            return rets.get(0);
        }
        return null;
    }

    protected T findFirst(String propertyName, Object value) {
        List<T> rets = this.findBy(propertyName, value);
        if (rets != null && rets.size() > 0) {
            return rets.get(0);
        }
        return null;
    }

    protected T findFirst(String hql, Object ... values) {
        List rets = this.createQuery(hql, values).list();
        if (rets != null && rets.size() > 0) {
            return (T)rets.get(0);
        }
        return null;
    }

    protected int batchExecute(String hql, Object ... values) {
        return this.createQuery(hql, values).executeUpdate();
    }

    protected Criteria createCriteria() {
        return this.createCriteria(this.entityClass);
    }

    protected Criteria createCriteria(Criterion ... criterions) {
        Criteria criteria = this.session().createCriteria(this.entityClass);
        for (Criterion c : criterions) {
            criteria.add(c);
        }
        return criteria;
    }

    protected GenericRepositoryImpl.PagingQuery<T> pagingQuery(Paging paging) {
        return this.pagingQuery(paging, this.entityClass, null);
    }

    protected GenericRepositoryImpl.PagingQuery<T> pagingQuery(Paging paging, Criterion ... criterions) {
        GenericRepositoryImpl.PagingQuery<T> q = this.pagingQuery(paging, this.entityClass, null);
        for (Criterion c : criterions) {
            q.add(c);
        }
        return q;
    }

    protected GenericRepositoryImpl.PagingQuery<T> pagingQuery(Paging paging, String cacheRegion) {
        return this.pagingQuery(paging, this.entityClass, cacheRegion);
    }

    @Override
    public List<T> list() {
        return this.createCriteria().list();
    }
}

