/*
 * Decompiled with CFR 0.152.
 */
package mtons.modules.persist.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import mtons.modules.persist.GenericRepository;
import mtons.modules.pojos.Paging;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.transform.ResultTransformer;
import org.springframework.util.Assert;

public class GenericRepositoryImpl
implements GenericRepository {
    private static final long serialVersionUID = -1108549180370324076L;
    protected SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected void enableFilter(String name) {
        this.session().enableFilter(name);
    }

    protected Session session() {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public void save(Object entity) {
        Assert.notNull((Object)entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.session().save(entity).hashCode();
    }

    @Override
    public void delete(Object entity) {
        Assert.notNull((Object)entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.session().delete(entity);
    }

    @Override
    public void update(Object entity) {
        Assert.notNull((Object)entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.session().update(entity);
    }

    @Override
    public void saveOrUpdate(Object entity) {
        Assert.notNull((Object)entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.session().saveOrUpdate(entity);
    }

    @Override
    public void refresh(Object entity) {
        Assert.notNull((Object)entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        this.session().refresh(entity);
    }

    @Override
    public Object merge(Object entity) {
        Assert.notNull((Object)entity, (String)"entity\u4e0d\u80fd\u4e3a\u7a7a");
        return this.session().merge(entity);
    }

    public <E> E get(Class<E> clazz, Serializable id) {
        return (E)this.session().get(clazz, id);
    }

    protected void deleteById(Class<?> clazz, Serializable id) {
        Session s = this.session();
        Object obj = s.get(clazz, id);
        if (obj != null) {
            s.delete(obj);
        }
    }

    @Override
    public Query createQuery(String hql, Object ... values) {
        Assert.hasText((String)hql, (String)"hql\u4e0d\u80fd\u4e3a\u7a7a");
        Query query = this.session().createQuery(hql);
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
        }
        return query;
    }

    protected Query createQuery(String hql) {
        return this.createQuery(hql, true, null);
    }

    protected Query createQuery(String hql, boolean cacheable) {
        return this.createQuery(hql, cacheable, null);
    }

    protected Query createQuery(String hql, boolean cacheable, String cacheRegion) {
        Query q = this.session().createQuery(hql).setCacheable(true);
        if (cacheable && cacheRegion != null) {
            q.setCacheRegion(cacheRegion);
        }
        return q;
    }

    protected SQLQuery createSQLQuery(String sql) {
        return this.session().createSQLQuery(sql);
    }

    protected Criteria createCriteria(Class<?> clazz) {
        return this.session().createCriteria(clazz).setCacheable(true);
    }

    protected <E> PagingQuery<E> pagingQuery(Paging paging, Class<E> clazz) {
        return new PagingQuery<E>(paging, clazz, null);
    }

    protected <E> PagingQuery<E> pagingQuery(Paging paging, Class<E> clazz, String cacheRegion) {
        return new PagingQuery<E>(paging, clazz, cacheRegion);
    }

    protected class QueryFilter {
        LinkedList<Criterion> criterions = new LinkedList();
        LinkedHashMap<String, String> aliases = new LinkedHashMap();

        protected QueryFilter() {
        }

        public QueryFilter add(Criterion c) {
            this.criterions.add(c);
            return this;
        }

        public QueryFilter alias(String field, String alias) {
            this.aliases.put(field, alias);
            return this;
        }

        public void doFilter(Criteria criteria) {
            if (!this.criterions.isEmpty()) {
                if (!this.aliases.isEmpty()) {
                    this.aliases.forEach((k, v) -> criteria.createAlias(k, v));
                }
                this.criterions.forEach(ct -> criteria.add(ct));
            }
        }
    }

    protected class PagingQuery<T>
    implements Serializable {
        private static final long serialVersionUID = 8307596869106859651L;
        String cacheRegion;
        Class<T> clazz;
        QueryFilter filter;
        LinkedList<Order> orderBuffer;
        ResultTransformer resultTransformer;
        Paging paging;

        public PagingQuery(Paging paging, Class<T> clazz, String cacheRegion) {
            this.filter = new QueryFilter();
            this.orderBuffer = new LinkedList();
            this.clazz = clazz;
            this.cacheRegion = cacheRegion;
            this.paging = paging;
        }

        public PagingQuery<T> add(Order order) {
            this.orderBuffer.add(order);
            return this;
        }

        public PagingQuery<T> asc(String field) {
            this.add(Order.asc((String)field));
            return this;
        }

        public PagingQuery<T> desc(String field) {
            this.add(Order.desc((String)field));
            return this;
        }

        public PagingQuery<T> alias(String field, String alias) {
            this.filter.alias(field, alias);
            return this;
        }

        public PagingQuery<T> add(Criterion c) {
            this.filter.add(c);
            return this;
        }

        public PagingQuery<T> setResultTransformer(ResultTransformer resultTransformer) {
            this.resultTransformer = resultTransformer;
            return this;
        }

        protected Criteria criteria(boolean sortable) {
            Criteria c = GenericRepositoryImpl.this.createCriteria(this.clazz);
            this.filter.doFilter(c);
            if (this.cacheRegion != null) {
                c.setCacheRegion(this.cacheRegion);
            }
            if (sortable && !this.orderBuffer.isEmpty()) {
                this.orderBuffer.forEach(o -> c.addOrder(o));
            }
            return c;
        }

        public List<T> list() {
            boolean hasData = true;
            if (this.paging.isCount()) {
                Criteria ctr = this.criteria(false);
                int totalRows = ((Number)ctr.setProjection(Projections.rowCount()).uniqueResult()).intValue();
                this.paging.setTotalCount(totalRows);
                if (totalRows <= this.paging.getFirstResult()) {
                    hasData = false;
                }
            }
            List results = Collections.emptyList();
            if (hasData) {
                Criteria ctr = this.criteria(true);
                ctr.setFirstResult(this.paging.getFirstResult()).setMaxResults(this.paging.getMaxResults());
                if (this.resultTransformer != null) {
                    ctr.setResultTransformer(this.resultTransformer);
                }
                results = ctr.list();
            }
            this.paging.setResults(results);
            return results;
        }
    }
}

