/*
 * Decompiled with CFR 0.152.
 */
package mtons.modules.pojos;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Paging
implements Serializable {
    private static final long serialVersionUID = -6480389889447195271L;
    public static final int DEFAULT_RESULTS = 15;
    private int pageNo = 1;
    private int maxResults = 15;
    private List<?> results = Collections.EMPTY_LIST;
    private int totalCount;
    private boolean count = true;

    public Paging() {
    }

    public Paging(int maxResults) {
        this.setPageNo(1);
        this.setMaxResults(maxResults);
    }

    public Paging(int pageNo, int maxResults) {
        this.setPageNo(pageNo);
        this.setMaxResults(maxResults);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public List<?> getResults() {
        return this.results;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getFirstResult() {
        return (this.pageNo - 1) * this.maxResults;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo < 1 ? 1 : pageNo;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults < 0 ? 0 : maxResults;
    }

    public void setResults(List<?> results) {
        this.results = results;
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public int getPageCount() {
        if (this.maxResults == 0) {
            return 1;
        }
        return (int)Math.ceil((double)this.totalCount * 1.0 / (double)this.maxResults);
    }

    public int getSize() {
        return this.results.size();
    }

    public int getPrev() {
        return this.pageNo > 1 ? this.pageNo - 1 : 0;
    }

    public int getNext() {
        int pc = this.getPageCount();
        return this.pageNo < pc ? this.pageNo + 1 : pc;
    }

    public boolean isCount() {
        return this.count;
    }

    public void setCount(boolean count) {
        this.count = count;
    }
}

