/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.generator.impl;

import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.config.MapperConfig;
import com.mybatisflex.codegen.config.PackageConfig;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.codegen.generator.IGenerator;
import com.mybatisflex.core.util.StringUtil;
import java.io.File;
import java.util.HashMap;

public class MapperGenerator
implements IGenerator {
    private String templatePath;

    public MapperGenerator() {
        this("/templates/enjoy/mapper.tpl");
    }

    public MapperGenerator(String templatePath) {
        this.templatePath = templatePath;
    }

    @Override
    public void generate(Table table, GlobalConfig globalConfig) {
        String mapperPackagePath;
        if (!globalConfig.isMapperGenerateEnable()) {
            return;
        }
        PackageConfig packageConfig = globalConfig.getPackageConfig();
        MapperConfig mapperConfig = globalConfig.getMapperConfig();
        String sourceDir = StringUtil.hasText((String)mapperConfig.getSourceDir()) ? mapperConfig.getSourceDir() : packageConfig.getSourceDir();
        File mapperJavaFile = new File(sourceDir, (mapperPackagePath = packageConfig.getMapperPackage().replace(".", "/")) + "/" + table.buildMapperClassName() + (Object)((Object)globalConfig.getFileType()));
        if (mapperJavaFile.exists() && !mapperConfig.isOverwriteEnable()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("table", table);
        params.put("mapperConfig", mapperConfig);
        params.put("packageConfig", packageConfig);
        params.put("javadocConfig", globalConfig.getJavadocConfig());
        params.putAll(globalConfig.getCustomConfig());
        globalConfig.getTemplateConfig().getTemplate().generate(params, this.templatePath, mapperJavaFile);
        System.out.println("Mapper ---> " + mapperJavaFile);
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }
}

